/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.DescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.LoaderNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginMavenClassLoaderModelLoader;

public class ToolingDescriptorLoaderRepository
implements DescriptorLoaderRepository {
    private Map<Class, List<DescriptorLoader>> descriptorLoaders = Maps.newHashMap();

    public ToolingDescriptorLoaderRepository(PluginMavenClassLoaderModelLoader pluginMavenClassLoaderModelLoader) {
        this.descriptorLoaders.put(BundleDescriptorLoader.class, this.findBundleDescriptorLoaders(BundleDescriptorLoader.class, new SpiServiceRegistry()));
        this.descriptorLoaders.put(ClassLoaderModelLoader.class, Lists.newArrayList((Object[])new DescriptorLoader[]{pluginMavenClassLoaderModelLoader}));
    }

    private List<DescriptorLoader> findBundleDescriptorLoaders(Class<? extends DescriptorLoader> descriptorLoaderClass, SpiServiceRegistry serviceRegistry) {
        ArrayList<DescriptorLoader> descriptorLoaders = new ArrayList<DescriptorLoader>();
        Collection providers = serviceRegistry.lookupProviders(descriptorLoaderClass, this.getClass().getClassLoader());
        for (DescriptorLoader loader : providers) {
            descriptorLoaders.add(loader);
        }
        return descriptorLoaders;
    }

    public <T extends DescriptorLoader> T get(String id, ArtifactType artifactType, Class<T> loaderClass) throws LoaderNotFoundException {
        DescriptorLoader descriptorLoader = null;
        List<DescriptorLoader> registeredDescriptorLoaders = this.descriptorLoaders.get(loaderClass);
        if (registeredDescriptorLoaders != null) {
            for (DescriptorLoader loader : registeredDescriptorLoaders) {
                if (!loader.getId().equals(id) || !loader.supportsArtifactType(artifactType)) continue;
                descriptorLoader = loader;
            }
        }
        if (descriptorLoader == null) {
            throw new LoaderNotFoundException(String.format("There is no loader with ID='%s' and type '%s'", id, loaderClass.getName()));
        }
        return (T)descriptorLoader;
    }
}

