/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;

import java.util.Optional;
import java.util.Set;

/**
 * Creates a {@link org.mule.datasense.api.metadataprovider.ApplicationModel} from the application.
 *
 * @since 4.0
 */
public interface ApplicationModelFactory {

  /**
   * Creates the {@link ApplicationModel} from the application.
   *
   * @param applicationDescriptor {@link ApplicationDescriptor} for application.
   * @param extensionModels {@link Set} of {@link ExtensionModel extension models} to be used for generating the application model.
   * @param applicationClassLoader {@link ClassLoader} for the application to resolve resources.
   * @return an {@link Optional} {@link ApplicationModel}.
   * @throws Exception if an error happens while generating the {@link ApplicationModel}.
   */
  Optional<ApplicationModel> createApplicationModel(ApplicationDescriptor applicationDescriptor,
                                                    Set<ExtensionModel> extensionModels,
                                                    ClassLoader applicationClassLoader);

}
