/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.ExtensionModelService;

import java.io.File;
import java.util.List;
import java.util.Optional;

/**
 * {@link ExtensionModelService} that use a cache for {@link ExtensionModel}s
 */
public class CachedExtensionModelService implements MuleRuntimeExtensionModelProvider {

  private ExtensionModelServiceCache extensionModelServiceCache;
  private InternalExtensionModelService extensionModelService;

  /**
   * Creates a new instance
   * 
   * @param extensionModelServiceCache the cache for {@link ExtensionModel}s
   * @param extensionModelService the service to use to load {@link ExtensionModel}s in case of a cache miss.
   */
  public CachedExtensionModelService(ExtensionModelServiceCache extensionModelServiceCache,
                                     InternalExtensionModelService extensionModelService) {
    this.extensionModelServiceCache = extensionModelServiceCache;
    this.extensionModelService = extensionModelService;
  }

  @Override
  public Optional<ExtensionModel> getExtensionModel(ArtifactDescriptor pluginDescriptor) {
    return extensionModelServiceCache.loadExtensionModel(pluginDescriptor, extensionModelService);
  }

  @Override
  public Optional<ExtensionModel> getExtensionModel(File plugin) {
    return extensionModelServiceCache.loadExtensionModel(plugin, extensionModelService);
  }

  @Override
  public List<ExtensionModel> getMuleExtensionModels() {
    return extensionModelServiceCache.loadMuleExtensionModels(extensionModelService);
  }
}
