/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Interface for loading {@link ComponentBuildingDefinition}s from a {@link ComponentBuildingDefinitionProvider}s.
 */
public interface ComponentBuildingDefinitionLoader {

  Function<ComponentBuildingDefinitionProvider, List<ComponentBuildingDefinition>> loadComponentBuildingDefinitions(Set<ExtensionModel> allExtensionModels);

}
