/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import static org.mule.tooling.client.internal.utils.IOUtils.readContentFromUrl;
import org.mule.tooling.agent.RuntimeToolingService;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

/**
 * Handles an {@link InputStream} with the content of the zipped application from local file system or a remote server.
 *
 * @since 4.0
 */
public class InputStreamApplicationDeployer extends AbstractApplicationDeployer {

  private static final int CONNECT_TIMEOUT = 5000;
  private static final int READ_TIMEOUT = 5000;

  public InputStreamApplicationDeployer(URL applicationUrl, RuntimeToolingService runtimeToolingService) {
    super(applicationUrl, runtimeToolingService);
  }

  @Override
  protected String doInternalInit(URL applicationUrlContent, RuntimeToolingService runtimeToolingService) {
    if (LOGGER.isDebugEnabled()) {
      LOGGER.debug("Deploying application from URL: {}", applicationUrlContent);
    }

    // TODO this should be configured in Builder for tooling runtimne client (TLS may be needed too)
    byte[] content = readContentFromUrl(applicationUrlContent, CONNECT_TIMEOUT, READ_TIMEOUT);
    return runtimeToolingService.deployApplication(new ByteArrayInputStream(content));
  }

}
