/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.api.DataSense;
import org.mule.datasense.api.DataSenseComponentInfo;
import org.mule.datasense.api.DataSenseInfo;
import org.mule.datasense.api.DataSenseResolutionScope;
import org.mule.datasense.api.metadataprovider.CachedDataSenseProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.api.metadataprovider.DefaultApplicationModel;
import org.mule.datasense.api.metadataprovider.DefaultDataSenseProvider;
import org.mule.datasense.api.metadataprovider.ExtensionsProvider;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.api.datasense.DataSenseResolveRequest;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.DataSensePartsFactory;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.TimeoutMethodUtils;
import org.mule.tooling.client.internal.ToolingDataSenseMetadataProvider;
import org.mule.tooling.client.internal.application.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSenseService
implements DataSenseService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String APP_TYPES_DATA = "application-types.xml";
    private DataSense dataSense = new DefaultDataSense();
    private Application application;
    private MetadataProvider metadataProvider;
    private AtomicBoolean disposed = new AtomicBoolean(false);

    public DefaultDataSenseService(Application application, MetadataProvider metadataProvider) {
        Preconditions.checkNotNull((Object)application, (Object)"application cannot be null");
        Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        this.application = application;
        this.metadataProvider = metadataProvider;
    }

    public Optional<org.mule.tooling.client.api.datasense.DataSenseInfo> resolveDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        return DataSensePartsFactory.toDataSenseInfoDTO(this.internalResolveDataSense(dataSenseRequest));
    }

    public Optional<org.mule.tooling.client.api.datasense.DataSenseComponentInfo> resolveComponentDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        return DataSensePartsFactory.toDataSenseComponentInfoDTO(this.internalResolveComponentDataSense(dataSenseRequest));
    }

    public Optional<DataSenseInfo> internalResolveDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        Location location = dataSenseRequest.getLocation();
        DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider = dataSenseRequest.getDataSenseMetadataCacheProvider();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Resolving DataSense for component location: %s on %s", dataSenseRequest.getLocation(), this.application));
        }
        return TimeoutMethodUtils.withTimeout(dataSenseRequest.getRequestTimeout(), () -> {
            try {
                DataSenseResolutionScope dataSenseResolutionScope;
                org.mule.datasense.api.metadataprovider.ApplicationModel applicationModel = this.buildDataSenseApplicationModel(this.application);
                DataSenseProvider dataSenseProvider = this.getDataSenseProvider(applicationModel, () -> ImmutableSet.builder().addAll(this.application.getExtensionModels()).build(), dataSenseMetadataCacheProvider, dataSenseRequest);
                DataSenseResolutionScope dataSenseResolutionScope2 = dataSenseResolutionScope = dataSenseRequest instanceof DataSenseResolveRequest ? ((DataSenseResolveRequest)dataSenseRequest).getDataSenseResolutionScope() : null;
                if (dataSenseResolutionScope == null) {
                    return (Optional)ClassUtils.withContextClassLoader((ClassLoader)this.application.getArtifactClassLoader().getClassLoader(), () -> this.dataSense.resolve(location, applicationModel, dataSenseProvider));
                }
                return (Optional)ClassUtils.withContextClassLoader((ClassLoader)this.application.getArtifactClassLoader().getClassLoader(), () -> this.dataSense.resolve(dataSenseResolutionScope, applicationModel, dataSenseProvider));
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, MissingToolingConfigurationException.class);
                throw new ToolingException(String.format("Error while resolving DataSense for location: %s on %s", location, this.application), (Throwable)e);
            }
        }, Optional.empty(), Optional.empty());
    }

    public Optional<DataSenseComponentInfo> internalResolveComponentDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        Location location = dataSenseRequest.getLocation();
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider = dataSenseRequest.getDataSenseMetadataCacheProvider();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Resolving DataSense for location: %s on %s", dataSenseRequest.getLocation(), this.application));
        }
        return TimeoutMethodUtils.withTimeout(dataSenseRequest.getRequestTimeout(), () -> {
            try {
                org.mule.datasense.api.metadataprovider.ApplicationModel applicationModel = this.buildDataSenseApplicationModel(this.application);
                DataSenseProvider dataSenseProvider = this.getDataSenseProvider(applicationModel, () -> ImmutableSet.builder().addAll(this.application.getExtensionModels()).build(), dataSenseMetadataCacheProvider, dataSenseRequest);
                return (Optional)ClassUtils.withContextClassLoader((ClassLoader)this.application.getArtifactClassLoader().getClassLoader(), () -> this.dataSense.resolveComponent(location, applicationModel, dataSenseProvider));
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, MissingToolingConfigurationException.class);
                throw new ToolingException(String.format("Error while resolving DataSense for location %s on %s", location, this.application), (Throwable)e);
            }
        }, Optional.empty(), Optional.empty());
    }

    public void dispose() {
        this.disposed.compareAndSet(false, true);
    }

    private org.mule.datasense.api.metadataprovider.ApplicationModel buildDataSenseApplicationModel(Application application) {
        String applicationName = application.getApplicationName();
        ApplicationModel applicationModel = application.getApplicationModel();
        InputStream appTypeData = application.getArtifactClassLoader().getClassLoader().getResourceAsStream(APP_TYPES_DATA);
        String typesData = null;
        if (appTypeData != null) {
            this.logger.debug("Found application custom types data");
            try {
                typesData = IOUtils.toString((InputStream)appTypeData);
            }
            catch (IOException e) {
                throw new ToolingException(String.format("Error while reading application custom types file for %s", application), (Throwable)e);
            }
        }
        return new DefaultApplicationModel(applicationName, applicationModel, typesData, resource -> Optional.ofNullable(application.getArtifactClassLoader().getClassLoader().getResource((String)resource)).map(url -> {
            try {
                return url.toURI();
            }
            catch (URISyntaxException e) {
                throw new ToolingException("Error while getting URI", (Throwable)e);
            }
        }));
    }

    private DataSenseProvider getDataSenseProvider(org.mule.datasense.api.metadataprovider.ApplicationModel applicationModel, ExtensionsProvider extensionsProvider, DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider, DataSenseRequest request) {
        DefaultDataSenseProvider dataSenseProvider = new DefaultDataSenseProvider(extensionsProvider, (DataSenseMetadataProvider)new ToolingDataSenseMetadataProvider(this.metadataProvider, request.getMetadataTimeout()));
        if (dataSenseMetadataCacheProvider != null) {
            dataSenseProvider = new CachedDataSenseProvider(applicationModel, dataSenseMetadataCacheProvider, (DataSenseProvider)dataSenseProvider);
        }
        return dataSenseProvider;
    }

    private void checkState() {
        Preconditions.checkState((!this.disposed.get() ? 1 : 0) != 0, (Object)"Service already disposed, cannot be used anymore");
    }
}

