/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mulesoft.agent.domain.tooling.BundleDescriptor;
import java.util.List;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.artifact.ConnectivityTestingServiceBuilder;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.internal.TemporaryConnectivityTestingService;

public class TemporaryConnectivityTestingServiceBuilder
implements ConnectivityTestingServiceBuilder {
    private List<BundleDescriptor> dependencies = Lists.newArrayList();
    private ArtifactDeclaration artifactDeclaration;
    private RuntimeToolingService runtimeToolingService;

    public TemporaryConnectivityTestingServiceBuilder(RuntimeToolingService runtimeToolingService) {
        Preconditions.checkNotNull((Object)runtimeToolingService, (Object)"runtimeToolingService cannot be null");
        this.runtimeToolingService = runtimeToolingService;
    }

    public ConnectivityTestingServiceBuilder addDependency(String groupId, String artifactId, String version, String classifier, String type) {
        BundleDescriptor artifactBundle = new BundleDescriptor();
        artifactBundle.setGroupId(groupId);
        artifactBundle.setArtifactId(artifactId);
        artifactBundle.setVersion(version);
        artifactBundle.setClassifier(classifier);
        artifactBundle.setType(type);
        this.dependencies.add(artifactBundle);
        return this;
    }

    public ConnectivityTestingServiceBuilder setArtifactDeclaration(ArtifactDeclaration artifactDeclaration) {
        this.artifactDeclaration = artifactDeclaration;
        return this;
    }

    public ConnectivityTestingService build() {
        return new TemporaryConnectivityTestingService(this.runtimeToolingService, this.dependencies, this.artifactDeclaration);
    }
}

