/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import java.io.File;
import java.util.List;
import java.util.Optional;

public interface InternalExtensionModelService {

  /**
   * Loads the {@link ExtensionModel} for the given plugin.
   *
   * @param pluginDescriptor {@link ArtifactDescriptor} referencing to the plugin artifact.
   * @return {@link ExtensionModel} for the plugin along with its class loader or {@link Optional#empty()} if the plugin doesn't
   *         have an {@link ExtensionModel}.
   */
  Optional<LoadedExtensionInformation> loadExtensionData(ArtifactDescriptor pluginDescriptor);

  /**
   * Loads the {@link ExtensionModel} for the given plugin.
   *
   * @param file {@link ArtifactDescriptor} referencing to the plugin artifact file.
   * @return {@link ExtensionModel} for the plugin along with its class loader or {@link Optional#empty()} if the plugin doesn't
   *         have an {@link ExtensionModel}.
   */
  Optional<LoadedExtensionInformation> loadExtensionData(File file);

  /**
   * Loads the {@link ExtensionModel} for Mule Runtime core components.
   *
   * @return {@link ExtensionModel} for Mule Runtime core components.
   */
  List<ExtensionModel> loadMuleExtensionModels();

}
