/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;

import java.io.File;
import java.io.IOException;

/**
 * Creates an {@link ArtifactClassLoader} from the location of the application (exploded or the jar).
 *
 * @since 4.0
 */
public interface ApplicationService {

  /**
   * Creates an {@link ArtifactClassLoader} from the given application location, could be the jar file or the exploded directory.
   *
   * @param applicationName name for the application.
   * @param applicationLocation location of the application as jar or exploded.
   * @param workingDirectory to be used by deployment to write or copy files.
   * @return {@link ArtifactClassLoader} for the given application.
   * @throws IOException if there was an error while creating the {@link ArtifactClassLoader}
   */
  ArtifactClassLoader createApplicationClassLoader(String applicationName, File applicationLocation, File workingDirectory)
      throws IOException;

}
