/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.dataweave;

import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.api.dataweave.validation.DataWeaveValidationRequest;
import org.mule.tooling.client.api.dataweave.validation.DataWeaveValidationResponse;

public interface DataWeaveRunner {

  /**
   * Run DataWeave script with given parameters.
   * 
   * @param parameters required for running dataWeave script.
   * @return a {@link DataWeavePreviewResponse} with execution result.
   * @throws Exception in case something script or parameters
   */
  DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters);

  /**
   * Validates DataWeave script with given parameters.
   * @param parameters required for validating dataWeave script.
   * @return a {@link DataWeaveValidationResponse} with execution result.
   * @throws Exception in case something script or parameters
   */
  DataWeaveValidationResponse validate(DataWeaveValidationRequest parameters);
}
