/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.dataweave;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.tooling.client.internal.application.Application;
import org.mule.weave.v2.el.WeaveExpressionLanguage;

/**
 * {@link DataWeaveRunner} that works with the {@link org.mule.tooling.client.internal.application.Application} {@link ClassLoader}.
 */
public class FatLocalRunner extends LocalRunner {

  public static final String DW_TRANSFORMATION = "output application/dw\n---\npayload";

  private Application application;

  public FatLocalRunner(Application application) {
    this.application = application;
  }

  @Override
  protected ClassLoader getExecutionClassLoader() {
    return application.getArtifactClassLoader().getClassLoader();
  }

  @Override
  protected String serializeObject(Object value, WeaveExpressionLanguage executor) {
    TypedValue result = executor.evaluate(DW_TRANSFORMATION, buildCustomTransformationPayload(value));
    return manageCursorStream(result);
  }

  private BindingContext buildCustomTransformationPayload(Object payload) {
    BindingContext.Builder bindingBuilder = BindingContext.builder();
    bindingBuilder.addBinding(PAYLOAD_ID, new org.mule.runtime.api.metadata.TypedValue<>(payload, DataType.fromObject(payload)));
    return bindingBuilder.build();
  }

}
