/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.utils;

import static org.apache.commons.io.IOUtils.copy;
import static org.mule.runtime.core.api.util.IOUtils.closeQuietly;
import org.mule.tooling.client.api.exception.ToolingException;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

/**
 * Utility class for IO operations.
 */
public final class IOUtils {

  public static byte[] readContentFromUrl(URL url, int connectTimeout, int readTimeout) {
    byte[] content;
    InputStream inputStream = null;
    OutputStream outputStream = null;
    try {
      URLConnection urlConnection = url.openConnection();
      urlConnection.setDefaultUseCaches(false);

      urlConnection.setConnectTimeout(connectTimeout);
      urlConnection.setReadTimeout(readTimeout);
      inputStream = new BufferedInputStream(urlConnection.getInputStream());
      ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();
      copy(inputStream, bufferOutputStream);
      content = bufferOutputStream.toByteArray();
    } catch (Exception e) {
      throw new ToolingException("Error while reading content from URL: " + url, e);
    } finally {
      closeQuietly(outputStream);
      closeQuietly(inputStream);
    }
    return content;
  }


}
