/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.util.LazyValue;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.exception.ToolingArtifactNotFoundException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.tryit.TryItService;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.mule.tooling.client.internal.DefaultToolingArtifact;
import org.mule.tooling.client.internal.DefaultToolingArtifactContext;
import org.mule.tooling.client.internal.DefaultTryItService;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.ToolingArtifactWrapper;
import org.mule.tooling.client.internal.ToolingExtensionModelAdapter;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.ApplicationService;
import org.mule.tooling.client.internal.application.DefaultApplication;
import org.mule.tooling.client.internal.artifact.DefaultArtifactSerializationService;

class DefaultToolingRuntimeClient
implements ToolingRuntimeClient {
    private DefaultToolingArtifactContext context;
    private ArtifactSerializationService artifactSerializationService;
    private TryItService tryItService;
    private ExtensionModelService extensionModelService;

    DefaultToolingRuntimeClient(MavenClient mavenClient, Optional<AgentConfiguration> agentConfigurationOptional, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader, ApplicationService applicationService, ApplicationCache applicationCache, Optional<InputStream> logConfig) {
        Preconditions.checkNotNull((Object)mavenClient, (Object)"aetherDependencyResolver cannot be null");
        Preconditions.checkNotNull(agentConfigurationOptional, (Object)"agentConfigurationOptional cannot be null");
        Preconditions.checkNotNull((Object)muleRuntimeExtensionModelProvider, (Object)"muleRuntimeExtensionModelProvider cannot be null");
        Preconditions.checkNotNull((Object)applicationService, (Object)"applicationService cannot be null");
        Preconditions.checkNotNull((Object)applicationCache, (Object)"applicationCache cannot be null");
        this.context = new DefaultToolingArtifactContext();
        logConfig.ifPresent(config -> this.context.setLoggingConfiguration((InputStream)config));
        this.context.setAgentConfiguration(agentConfigurationOptional);
        this.context.setMavenClient(mavenClient);
        this.context.setMuleRuntimeExtensionModelProvider(muleRuntimeExtensionModelProvider);
        this.context.setComponentBuildingDefinitionLoader(componentBuildingDefinitionLoader);
        this.context.setApplicationService(applicationService);
        this.context.setApplicationCache(applicationCache);
        this.artifactSerializationService = new DefaultArtifactSerializationService(muleRuntimeExtensionModelProvider.getMuleExtensionModels(), muleRuntimeExtensionModelProvider, mavenClient);
        this.tryItService = new DefaultTryItService((LazyValue<RuntimeToolingService>)new LazyValue(() -> this.context.getRuntimeToolingService()));
        this.extensionModelService = new ToolingExtensionModelAdapter(muleRuntimeExtensionModelProvider);
    }

    public TryItService tryItService() {
        return this.tryItService;
    }

    public ExtensionModelService extensionModelService() {
        return this.extensionModelService;
    }

    public ArtifactSerializationService artifactSerializationService() {
        return this.artifactSerializationService;
    }

    public ToolingArtifact newToolingArtifact(URL applicationUrlContent) {
        String id = UUID.randomUUID().toString();
        ApplicationCache applicationCache = this.context.getApplicationCache();
        Application application = applicationCache.getApplication(id, () -> new DefaultApplication(applicationUrlContent, this.context));
        return this.newToolingArtifact(id, applicationCache, application);
    }

    public ToolingArtifact fetchToolingArtifact(String id) throws ToolingArtifactNotFoundException {
        Application application = this.context.getApplicationCache().getApplication(id, () -> {
            throw new ToolingArtifactNotFoundException(String.format("ToolingArtifact not found in cache for id: %s", id));
        });
        application.setContext(this.context);
        return this.newToolingArtifact(id, this.context.getApplicationCache(), application);
    }

    private ToolingArtifact newToolingArtifact(final String id, final ApplicationCache applicationCache, Application application) {
        return new ToolingArtifactWrapper(new DefaultToolingArtifact(id, application){

            @Override
            public void dispose() {
                applicationCache.invalidate(id);
            }
        });
    }
}

