/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.DefaultApplicationModelFactory;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.RemoteApplicationContextFactory;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplication
implements Application {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultApplication.class);
    private static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    private static final String FILE_PROTOCOL = "file";
    private URL applicationUrlContent;
    private ToolingArtifactContext context;
    private LazyValue<List<ExtensionModel>> extensionModels;
    private LazyValue<ArtifactClassLoader> applicationClassLoader;
    private LazyValue<ApplicationModel> applicationModel;
    private LazyValue<ApplicationResources> applicationResources;
    private String remoteApplicationId;
    private AtomicBoolean disposed = new AtomicBoolean(false);

    public DefaultApplication(URL applicationUrlContent, ToolingArtifactContext context) {
        Objects.requireNonNull(applicationUrlContent, "applicationUrlContent cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        this.applicationUrlContent = applicationUrlContent;
        this.context = context;
        this.applicationResources = this.newApplicationResourcesLazyValue();
        this.applicationModel = this.newApplicationModelLazyValue();
        this.applicationClassLoader = this.newApplicationClassLoaderLazyValue();
        this.extensionModels = this.newExtensionModelsLazyValue();
    }

    @Override
    public synchronized void setContext(ToolingArtifactContext context) {
        this.checkState();
        if (this.context != null && this.context.getAgentConfiguration().isPresent() && context.getAgentConfiguration().isPresent() && !this.context.getAgentConfiguration().get().getToolingApiUrl().equals(context.getAgentConfiguration().get().getToolingApiUrl())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Application context has changed, trying to dispose (if present) the remote application");
            }
            this.disposeRemoteApplicationContext();
        }
        this.context = context;
    }

    @Override
    public List<ExtensionModel> getExtensionModels() {
        this.checkState();
        return (List)this.extensionModels.get();
    }

    private boolean isFileProtocol() {
        return this.applicationUrlContent.getProtocol().equals(FILE_PROTOCOL);
    }

    @Override
    public String getApplicationName() {
        this.checkState();
        return this.getArtifactClassLoader().getArtifactId();
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        this.checkState();
        return (ArtifactClassLoader)this.applicationClassLoader.get();
    }

    private ApplicationDescriptor getApplicationDescriptor() {
        this.checkState();
        return (ApplicationDescriptor)this.getArtifactClassLoader().getArtifactDescriptor();
    }

    @Override
    public synchronized <R> R evaluateWithRemoteApplication(RemoteApplicationInvoker.ApplicationRemoteFunction<R> function) {
        this.checkState();
        RuntimeToolingService runtimeToolingService = this.context.getRuntimeToolingService();
        try {
            if (this.remoteApplicationId == null) {
                this.remoteApplicationId = RemoteApplicationContextFactory.createRemoteApplicationContext(this.applicationUrlContent, runtimeToolingService).deploy();
            }
            return this.doInvoke(function, this.remoteApplicationId, runtimeToolingService);
        }
        catch (NoSuchApplicationException e) {
            this.disposeRemoteApplicationQuietly(runtimeToolingService);
            this.remoteApplicationId = RemoteApplicationContextFactory.createRemoteApplicationContext(this.applicationUrlContent, runtimeToolingService).deploy();
            return this.doInvoke(function, this.remoteApplicationId, runtimeToolingService);
        }
    }

    public synchronized void dispose() {
        this.checkState();
        if (!this.disposed.getAndSet(true)) {
            this.disposeClassLoader();
            this.disposeResources();
            this.disposeRemoteApplicationContext();
        }
    }

    private void disposeRemoteApplicationContext() {
        if (this.remoteApplicationId != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing Mule Runtime remote application for applicationId: {}", (Object)this.remoteApplicationId);
            }
            this.disposeRemoteApplicationQuietly(this.context.getRuntimeToolingService());
            this.remoteApplicationId = null;
        }
    }

    private void disposeResources() {
        if (this.applicationResources.isComputed()) {
            File workingDirectory;
            boolean fileDeleted;
            ApplicationResources applicationResources = (ApplicationResources)this.applicationResources.get();
            if (!this.isFileProtocol()) {
                File applicationRootFile;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Deleting temporary file used for application");
                }
                if (!(fileDeleted = FileUtils.deleteQuietly((File)(applicationRootFile = applicationResources.getApplicationRootFile())))) {
                    LOGGER.warn("Couldn't delete temporary application file: {}", (Object)applicationRootFile.getAbsoluteFile());
                }
            }
            if ((workingDirectory = applicationResources.getWorkingDirectory()) != null && workingDirectory.exists() && !(fileDeleted = FileUtils.deleteQuietly((File)workingDirectory))) {
                LOGGER.warn("Couldn't delete temporary working application file: {}", (Object)workingDirectory.getAbsoluteFile());
            }
            this.applicationResources = null;
            this.applicationModel = null;
            this.extensionModels = null;
        }
    }

    private void disposeClassLoader() {
        if (this.applicationClassLoader.isComputed()) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Disposing application class loader");
                }
                ((ArtifactClassLoader)this.applicationClassLoader.get()).dispose();
            }
            finally {
                this.applicationClassLoader = null;
            }
        }
    }

    private void disposeRemoteApplicationQuietly(RuntimeToolingService runtimeToolingService) {
        try {
            runtimeToolingService.disposeApplication(this.remoteApplicationId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <R> R doInvoke(RemoteApplicationInvoker.ApplicationRemoteFunction<R> function, String remoteApplicationId, RuntimeToolingService runtimeToolingService) {
        return function.apply(remoteApplicationId, runtimeToolingService);
    }

    private boolean isApplicationExploded() {
        return this.isFileProtocol() && FileUtils.toFile((URL)this.applicationUrlContent).isDirectory();
    }

    @Override
    public ApplicationModel getApplicationModel() {
        this.checkState();
        return (ApplicationModel)this.applicationModel.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BundleDependency> resolveDependencies() {
        File workDir = com.google.common.io.Files.createTempDir();
        try {
            MavenClient mavenClient = this.context.getMavenClient();
            List list = mavenClient.resolveArtifactDependencies(((ApplicationResources)this.applicationResources.get()).getApplicationRootFile(), false, Optional.of(mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.of(workDir));
            return list;
        }
        finally {
            boolean fileDeleted = FileUtils.deleteQuietly((File)workDir);
            if (!fileDeleted) {
                LOGGER.warn("Couldn't delete temporary work directory: {}", (Object)workDir.getAbsoluteFile());
            }
        }
    }

    private LazyValue<ArtifactClassLoader> newApplicationClassLoaderLazyValue() {
        return new LazyValue(() -> {
            ApplicationResources applicationResources = (ApplicationResources)this.applicationResources.get();
            File applicationRootFile = applicationResources.getApplicationRootFile();
            try {
                return this.context.getApplicationService().createApplicationClassLoader(applicationRootFile.getName(), applicationRootFile, applicationResources.getWorkingDirectory());
            }
            catch (IOException e) {
                throw new ToolingException(String.format("Error while creating application class loader for application URL: %s using temporary application file: %s", this.applicationUrlContent, applicationRootFile));
            }
        });
    }

    private LazyValue<ApplicationModel> newApplicationModelLazyValue() {
        return new LazyValue(() -> new DefaultApplicationModelFactory(this.context.getComponentBuildingDefinitionLoader()).createApplicationModel(this.getApplicationDescriptor(), (Set<ExtensionModel>)ImmutableSet.builder().addAll(this.getExtensionModels()).build(), this.getArtifactClassLoader().getClassLoader()).orElseThrow(() -> new ToolingException(String.format("Couldn't create ApplicationModel from %s", this))));
    }

    private LazyValue<List<ExtensionModel>> newExtensionModelsLazyValue() {
        return new LazyValue(() -> this.resolveDependencies().stream().filter(dependency -> MULE_PLUGIN_CLASSIFIER.equals(dependency.getDescriptor().getClassifier().orElse(null))).map(dependency -> this.context.getMuleRuntimeExtensionModelProvider().getExtensionModel(new File(dependency.getBundleUri())).orElse(null)).filter(extensionModel -> extensionModel != null).collect(Collectors.toList()));
    }

    private LazyValue<ApplicationResources> newApplicationResourcesLazyValue() {
        return new LazyValue(() -> {
            boolean fileDeleted;
            ApplicationResources applicationResources;
            File tempFile;
            block24: {
                boolean fileDeleted2;
                tempFile = null;
                if (!this.isApplicationExploded()) break block24;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Application URL already references to a file location with the content exploded");
                }
                ApplicationResources applicationResources2 = new ApplicationResources(FileUtils.toFile((URL)this.applicationUrlContent), com.google.common.io.Files.createTempDir());
                if (tempFile != null && !(fileDeleted2 = FileUtils.deleteQuietly((File)tempFile))) {
                    LOGGER.warn("Couldn't delete temporary application file: {}", (Object)tempFile.getAbsoluteFile());
                }
                return applicationResources2;
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Application URL either references to a remote location or a file location with packaged jar, copying to a temporary folder");
                }
                File applicationRootFile = Files.createTempDirectory("application", new FileAttribute[0]).toFile();
                applicationRootFile.deleteOnExit();
                if (!this.isFileProtocol()) {
                    byte[] fileContent = org.mule.tooling.client.internal.utils.IOUtils.readContentFromUrl(this.applicationUrlContent, 5000, 5000);
                    tempFile = org.mule.runtime.core.api.util.FileUtils.createTempFile((String)"application", (String)".jar");
                    try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                        IOUtils.write((byte[])fileContent, (OutputStream)outputStream);
                    }
                } else {
                    tempFile = FileUtils.toFile((URL)this.applicationUrlContent);
                }
                org.mule.runtime.core.api.util.FileUtils.unzip((File)tempFile, (File)applicationRootFile);
                applicationResources = new ApplicationResources(applicationRootFile, applicationRootFile);
            }
            catch (IOException e) {
                try {
                    throw new ToolingException(String.format("Couldn't expand the application or content to a temporary folder from URL: %s", this.applicationUrlContent), (Throwable)e);
                }
                catch (Throwable throwable) {
                    boolean fileDeleted3;
                    if (tempFile != null && !(fileDeleted3 = FileUtils.deleteQuietly(tempFile))) {
                        LOGGER.warn("Couldn't delete temporary application file: {}", (Object)tempFile.getAbsoluteFile());
                    }
                    throw throwable;
                }
            }
            if (tempFile != null && !(fileDeleted = FileUtils.deleteQuietly((File)tempFile))) {
                LOGGER.warn("Couldn't delete temporary application file: {}", (Object)tempFile.getAbsoluteFile());
            }
            return applicationResources;
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{applicationUrlContent=" + this.applicationUrlContent + (this.applicationResources.isComputed() ? ", applicationRootFile=" + ((ApplicationResources)this.applicationResources.get()).getApplicationRootFile().getAbsolutePath() + "}" : "}");
    }

    private void checkState() {
        Preconditions.checkState((!this.disposed.get() ? 1 : 0) != 0, (Object)"Application already disposed, cannot be used anymore");
    }

    private class ApplicationResources {
        private File applicationRootFile;
        private File workingDirectory;

        public ApplicationResources(File applicationRootFile, File workingDirectory) {
            this.applicationRootFile = applicationRootFile;
            this.workingDirectory = workingDirectory;
        }

        public File getApplicationRootFile() {
            return this.applicationRootFile;
        }

        public File getWorkingDirectory() {
            return this.workingDirectory;
        }
    }
}

