/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.maven.client.api.MavenClient;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.internal.application.ApplicationService;

import java.util.Optional;

/**
 * Default implementation of {@link ToolingArtifactContext}.
 */
public class DefaultToolingArtifactContext implements ToolingArtifactContext {

  private SpiRuntimeToolingServiceProvider runtimeToolingServiceProvider = new SpiRuntimeToolingServiceProvider();
  private transient volatile boolean runtimeToolingServiceInitialized;
  private RuntimeToolingService runtimeToolingService;

  private Optional<AgentConfiguration> agentConfigurationOptional;
  private ApplicationCache applicationCache;
  private MavenClient mavenClient;
  private MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
  private ApplicationService applicationService;
  private Optional<MetadataCacheFactory> metadataCacheFactory;

  public void setAgentConfiguration(Optional<AgentConfiguration> agentConfigurationOptional) {
    this.agentConfigurationOptional = agentConfigurationOptional;
  }

  public Optional<AgentConfiguration> getAgentConfiguration() {
    return agentConfigurationOptional;
  }

  public RuntimeToolingService getRuntimeToolingService() {
    if (!this.runtimeToolingServiceInitialized) {
      synchronized (this) {
        if (!this.runtimeToolingServiceInitialized) {
          this.runtimeToolingService = runtimeToolingServiceProvider.lookUpRuntimeToolingService();

          if (!agentConfigurationOptional.isPresent()) {
            throw new MissingToolingConfigurationException("Tooling Client has to be configure with a configuration to access REST Tooling API in order to resolve operations");
          }

          AgentConfiguration agentConfiguration = agentConfigurationOptional.get();
          runtimeToolingService.setToolingApiUrl(agentConfiguration.getToolingApiUrl(),
                                                 agentConfiguration.getDefaultConnectTimeout(),
                                                 agentConfiguration.getDefaultReadTimeout(),
                                                 agentConfiguration.getSslConfiguration());

          this.runtimeToolingServiceInitialized = true;
        }
      }
    }
    return runtimeToolingService;
  }

  public ApplicationCache getApplicationCache() {
    return applicationCache;
  }

  public void setApplicationCache(ApplicationCache applicationCache) {
    this.applicationCache = applicationCache;
  }

  public void setMavenClient(MavenClient mavenClient) {
    this.mavenClient = mavenClient;
  }

  public MavenClient getMavenClient() {
    return mavenClient;
  }

  public void setMuleRuntimeExtensionModelProvider(MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider) {
    this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
  }

  public MuleRuntimeExtensionModelProvider getMuleRuntimeExtensionModelProvider() {
    return muleRuntimeExtensionModelProvider;
  }

  public void setApplicationService(ApplicationService applicationService) {
    this.applicationService = applicationService;
  }

  public ApplicationService getApplicationService() {
    return applicationService;
  }

  public void setMetadataCacheFactory(Optional<MetadataCacheFactory> metadataCacheFactory) {
    this.metadataCacheFactory = metadataCacheFactory;
  }

  public Optional<MetadataCacheFactory> getMetadataCacheFactory() {
    return metadataCacheFactory;
  }
}
