/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.exception.ToolingException;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;

/**
 * A proxy implementation that uses reflection to call a target instance implementation loaded by a different class loader.
 *
 * @since 4.0
 */
public class MetadataCacheFactoryProxy implements MetadataCacheFactory {

  private Object proxyTarget;

  public MetadataCacheFactoryProxy(Object proxyTarget) {
    requireNonNull(proxyTarget, "proxyTarget cannot be null");

    this.proxyTarget = proxyTarget;
  }

  @Override
  public MetadataCache createMetadataCache(String toolingArtifactId, URL applicationContentUrl,
                                           Map<String, String> toolingArtifactProperties) {
    try {
      Method method = proxyTarget.getClass().getMethod("createMetadataCache", String.class, URL.class, Map.class);
      method.setAccessible(true);
      return new MetadataCacheProxy(method.invoke(proxyTarget, toolingArtifactId, applicationContentUrl,
                                                  toolingArtifactProperties));
    } catch (Exception e) {
      throw new ToolingException("Error while calling proxy method on client code", e);
    }
  }

}
