/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.google.common.collect.ImmutableMap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.Transformer;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.declaration.type.annotation.DefaultImplementingTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DslBaseType;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.QNameTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;
import org.mule.tooling.client.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.internal.ExtensionModelPartsFactory;
import org.mule.tooling.client.internal.persistence.TypeAnnotationEntryKey;
import org.mule.tooling.client.internal.serialization.TypeIdAnnotationMapper;
import org.mule.tooling.client.internal.serialization.XStreamFactory;
import org.mule.tooling.client.internal.serialization.XmlArtifactDeserializationRequestConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtilsImpl {
    private static Logger LOGGER = LoggerFactory.getLogger(SerializationUtilsImpl.class);

    private static XStream createXStream() {
        XStream xStream = XStreamFactory.createXStream();
        xStream.registerConverter((Converter)new TypeAnnotationsMapConverter(xStream.getMapper()));
        xStream.registerConverter((Converter)new XmlArtifactDeserializationRequestConverter(xStream.getMapper()));
        return xStream;
    }

    public static String serialize(Object object) {
        return SerializationUtilsImpl.createXStream().toXML(object);
    }

    public static <T> T deserialize(String xml) {
        return (T)SerializationUtilsImpl.createXStream().fromXML(xml);
    }

    private static class TypeAnnotationsMapConverter
    extends MapConverter {
        private static final String ORG_MULE_METADATA = "org.mule.metadata";
        private static final String ORG_MULE_TOOLING_CLIENT_API = "org.mule.tooling.client.api";
        private static Map<Class, Transformer<TypeAnnotation, TypeAnnotation>> typeAnnotationTransformers = ImmutableMap.builder().put(DisplayTypeAnnotation.class, typeAnnotation -> {
            DisplayTypeAnnotation displayTypeAnnotation = (DisplayTypeAnnotation)typeAnnotation;
            DisplayModel displayModel = new DisplayModel(displayTypeAnnotation.getDisplayName(), displayTypeAnnotation.getSummary(), displayTypeAnnotation.getExample(), ExtensionModelPartsFactory.toPathModelDTO(displayTypeAnnotation.getPathModel()));
            return new org.mule.tooling.client.api.declaration.type.annotation.DisplayTypeAnnotation(displayModel);
        }).put(org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation.class, typeAnnotation -> {
            org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation typeDslAnnotation = (org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation)typeAnnotation;
            Optional<Object> substitutionGroup = Optional.empty();
            if (typeDslAnnotation.getSubstitutionGroup().isPresent()) {
                SubstitutionGroup originalSubstitutionGroup = (SubstitutionGroup)typeDslAnnotation.getSubstitutionGroup().get();
                substitutionGroup = Optional.of(new org.mule.tooling.client.api.declaration.type.annotation.SubstitutionGroup(originalSubstitutionGroup.getPrefix(), originalSubstitutionGroup.getElement()));
            }
            Optional<Object> dslBaseType = Optional.empty();
            if (typeDslAnnotation.getDslBaseType().isPresent()) {
                DslBaseType originalDslBaseType = (DslBaseType)typeDslAnnotation.getDslBaseType().get();
                dslBaseType = Optional.of(new org.mule.tooling.client.api.declaration.type.annotation.DslBaseType(originalDslBaseType.getPrefix(), originalDslBaseType.getType()));
            }
            return new TypeDslAnnotation(typeDslAnnotation.allowsInlineDefinition(), typeDslAnnotation.allowsTopLevelDefinition(), (org.mule.tooling.client.api.declaration.type.annotation.SubstitutionGroup)substitutionGroup.orElse(null), (org.mule.tooling.client.api.declaration.type.annotation.DslBaseType)dslBaseType.orElse(null));
        }).put(ExpressionSupportAnnotation.class, typeAnnotation -> {
            ExpressionSupportAnnotation expressionSupportAnnotation = (ExpressionSupportAnnotation)typeAnnotation;
            return new org.mule.tooling.client.api.declaration.type.annotation.ExpressionSupportAnnotation(ExtensionModelPartsFactory.toExpressionSupportDTO(expressionSupportAnnotation.getExpressionSupport()));
        }).put(org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation.class, typeAnnotation -> {
            org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation exclusiveOptionalsTypeAnnotation = (org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation)typeAnnotation;
            return new ExclusiveOptionalsTypeAnnotation(exclusiveOptionalsTypeAnnotation.getExclusiveParameterNames(), exclusiveOptionalsTypeAnnotation.isOneRequired());
        }).put(ExtensibleTypeAnnotation.class, typeAnnotation -> new org.mule.tooling.client.api.declaration.type.annotation.ExtensibleTypeAnnotation()).put(FlattenedTypeAnnotation.class, typeAnnotation -> new org.mule.tooling.client.api.declaration.type.annotation.FlattenedTypeAnnotation()).put(org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation.class, typeAnnotation -> {
            org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation layoutTypeAnnotation = (org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation)typeAnnotation;
            return new LayoutTypeAnnotation(ExtensionModelPartsFactory.toLayoutModelDTO(Optional.of(layoutTypeAnnotation.getLayoutModel())));
        }).put(ParameterDslAnnotation.class, typeAnnotation -> {
            ParameterDslAnnotation parameterDslAnnotation = (ParameterDslAnnotation)typeAnnotation;
            return new org.mule.tooling.client.api.declaration.type.annotation.ParameterDslAnnotation(parameterDslAnnotation.allowsInlineDefinition(), parameterDslAnnotation.allowsReferences());
        }).put(QNameTypeAnnotation.class, typeAnnotation -> {
            QNameTypeAnnotation qNameTypeAnnotation = (QNameTypeAnnotation)typeAnnotation;
            return new org.mule.tooling.client.api.declaration.type.annotation.QNameTypeAnnotation(qNameTypeAnnotation.getValue());
        }).put(org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation.class, typeAnnotation -> {
            org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation stereotypeTypeAnnotation = (org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation)typeAnnotation;
            return new StereotypeTypeAnnotation((List)ExtensionModelPartsFactory.toStereotypesDTO(stereotypeTypeAnnotation.getAllowedStereotypes(), new ArrayList()));
        }).put(DefaultImplementingTypeAnnotation.class, typeAnnotation -> {
            DefaultImplementingTypeAnnotation defaultImplementingTypeAnnotation = (DefaultImplementingTypeAnnotation)typeAnnotation;
            return new org.mule.tooling.client.api.declaration.type.annotation.DefaultImplementingTypeAnnotation(defaultImplementingTypeAnnotation.getDefaultType());
        }).build();
        private static Map<Class, Transformer<TypeAnnotation, TypeAnnotation>> toolingTypeAnnotationTransformers = ImmutableMap.builder().put(org.mule.tooling.client.api.declaration.type.annotation.DisplayTypeAnnotation.class, toolingTypeAnnotation -> {
            org.mule.tooling.client.api.declaration.type.annotation.DisplayTypeAnnotation displayTypeAnnotation = (org.mule.tooling.client.api.declaration.type.annotation.DisplayTypeAnnotation)toolingTypeAnnotation;
            DisplayModel.DisplayModelBuilder displayModelBuilder = org.mule.runtime.api.meta.model.display.DisplayModel.builder().displayName(displayTypeAnnotation.getDisplayName()).summary(displayTypeAnnotation.getSummary()).example(displayTypeAnnotation.getExample());
            displayTypeAnnotation.getPathModel().ifPresent(pathModel -> {
                pathModel.getFileExtensions();
                PathModel.Type type = PathModel.Type.ANY;
                try {
                    type = PathModel.Type.valueOf((String)pathModel.getType().getValue());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Couldn't find a PathModel.Type for name: {}", (Object)pathModel.getType().getValue());
                }
                displayModelBuilder.path(new PathModel(type, pathModel.acceptsUrls(), PathModel.Location.valueOf((String)pathModel.getLocation().getValue()), pathModel.getFileExtensions().toArray(new String[0])));
            });
            return new DisplayTypeAnnotation(displayModelBuilder.build());
        }).put(TypeDslAnnotation.class, toolingTypeAnnotation -> {
            TypeDslAnnotation typeDslAnnotation = (TypeDslAnnotation)toolingTypeAnnotation;
            return new org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation(typeDslAnnotation.allowsInlineDefinition(), typeDslAnnotation.allowsTopLevelDefinition(), (String)typeDslAnnotation.getSubstitutionGroup().map(substitutionGroup -> substitutionGroup.getFormattedAnnotation()).orElse(null), (String)typeDslAnnotation.getDslBaseType().map(dslBaseType -> dslBaseType.getFormattedAnnotation()).orElse(null));
        }).put(org.mule.tooling.client.api.declaration.type.annotation.ExpressionSupportAnnotation.class, toolingTypeAnnotation -> {
            org.mule.tooling.client.api.declaration.type.annotation.ExpressionSupportAnnotation expressionSupportAnnotation = (org.mule.tooling.client.api.declaration.type.annotation.ExpressionSupportAnnotation)toolingTypeAnnotation;
            ExpressionSupport expressionSupport = ExpressionSupport.NOT_SUPPORTED;
            try {
                expressionSupport = ExpressionSupport.valueOf((String)expressionSupportAnnotation.getExpressionSupport().getValue());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Couldn't find a ExpressionSupport for name: {}", (Object)expressionSupportAnnotation.getExpressionSupport().getValue());
            }
            return new ExpressionSupportAnnotation(expressionSupport);
        }).put(ExclusiveOptionalsTypeAnnotation.class, toolingTypeAnnotation -> {
            ExclusiveOptionalsTypeAnnotation exclusiveOptionalsTypeAnnotation = (ExclusiveOptionalsTypeAnnotation)toolingTypeAnnotation;
            return new org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation(exclusiveOptionalsTypeAnnotation.getExclusiveParameterNames(), exclusiveOptionalsTypeAnnotation.isOneRequired());
        }).put(org.mule.tooling.client.api.declaration.type.annotation.ExtensibleTypeAnnotation.class, toolingTypeAnnotation -> new ExtensibleTypeAnnotation()).put(org.mule.tooling.client.api.declaration.type.annotation.FlattenedTypeAnnotation.class, toolingTypeAnnotation -> new FlattenedTypeAnnotation()).put(LayoutTypeAnnotation.class, toolingTypeAnnotation -> {
            LayoutTypeAnnotation layoutTypeAnnotation = (LayoutTypeAnnotation)toolingTypeAnnotation;
            LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
            if (layoutTypeAnnotation.getLayoutModel().isPassword()) {
                layoutModelBuilder.asPassword();
            }
            if (layoutTypeAnnotation.getLayoutModel().isQuery()) {
                layoutModelBuilder.asQuery();
            }
            if (layoutTypeAnnotation.getLayoutModel().isText()) {
                layoutModelBuilder.asText();
            }
            layoutTypeAnnotation.getLayoutModel().getOrder().ifPresent(order -> layoutModelBuilder.order(order.intValue()));
            layoutTypeAnnotation.getLayoutModel().getTabName().ifPresent(tabName -> layoutModelBuilder.tabName(tabName));
            return new org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation(layoutModelBuilder.build());
        }).put(org.mule.tooling.client.api.declaration.type.annotation.ParameterDslAnnotation.class, toolingTypeAnnotation -> {
            org.mule.tooling.client.api.declaration.type.annotation.ParameterDslAnnotation parameterDslAnnotation = (org.mule.tooling.client.api.declaration.type.annotation.ParameterDslAnnotation)toolingTypeAnnotation;
            return new ParameterDslAnnotation(parameterDslAnnotation.allowsInlineDefinition(), parameterDslAnnotation.allowsReferences());
        }).put(org.mule.tooling.client.api.declaration.type.annotation.QNameTypeAnnotation.class, toolingTypeAnnotation -> {
            org.mule.tooling.client.api.declaration.type.annotation.QNameTypeAnnotation qNameTypeAnnotation = (org.mule.tooling.client.api.declaration.type.annotation.QNameTypeAnnotation)toolingTypeAnnotation;
            return new QNameTypeAnnotation(qNameTypeAnnotation.getValue());
        }).put(StereotypeTypeAnnotation.class, toolingTypeAnnotation -> {
            StereotypeTypeAnnotation stereotypeTypeAnnotation = (StereotypeTypeAnnotation)toolingTypeAnnotation;
            List allowedStereotypes = stereotypeTypeAnnotation.getStereotypeModel().stream().map(stereotypeModel -> TypeAnnotationsMapConverter.toStereotypeModel(stereotypeModel)).collect(Collectors.toList());
            return new org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation(allowedStereotypes);
        }).put(org.mule.tooling.client.api.declaration.type.annotation.DefaultImplementingTypeAnnotation.class, toolingTypeAnnotation -> {
            org.mule.tooling.client.api.declaration.type.annotation.DefaultImplementingTypeAnnotation defaultImplementingTypeAnnotation = (org.mule.tooling.client.api.declaration.type.annotation.DefaultImplementingTypeAnnotation)toolingTypeAnnotation;
            return new DefaultImplementingTypeAnnotation(defaultImplementingTypeAnnotation.getDefaultType());
        }).build();

        private static StereotypeModel toStereotypeModel(org.mule.tooling.client.api.extension.model.StereotypeModel stereotypeModel) {
            return new ImmutableStereotypeModel(stereotypeModel.getType(), stereotypeModel.getNamespace(), (StereotypeModel)stereotypeModel.getParent().map(parent -> TypeAnnotationsMapConverter.toStereotypeModel(parent)).orElse(null));
        }

        public TypeAnnotationsMapConverter(Mapper mapper) {
            super(mapper);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Map map = source;
            if (map.isEmpty()) {
                super.marshal((Object)source, writer, context);
                return;
            }
            Map.Entry entry = map.entrySet().iterator().next();
            if (entry.getKey() instanceof Class && TypeAnnotation.class.isAssignableFrom((Class)entry.getKey())) {
                Map typeAnnotationMap = map;
                LinkedHashMap<TypeAnnotationEntryKey, Object> toTypeAnnotationTransformedMap = new LinkedHashMap<TypeAnnotationEntryKey, Object>();
                for (Map.Entry e : typeAnnotationMap.entrySet()) {
                    if (!((TypeAnnotation)e.getValue()).isPublic()) continue;
                    if (typeAnnotationTransformers.containsKey(e.getKey())) {
                        TypeAnnotation transformed = (TypeAnnotation)typeAnnotationTransformers.get(e.getKey()).transform(e.getValue());
                        toTypeAnnotationTransformedMap.put(new TypeAnnotationEntryKey(transformed.getName()), transformed);
                        continue;
                    }
                    if (((Class)e.getKey()).getPackage().getName().startsWith(ORG_MULE_METADATA) || ((Class)e.getKey()).getPackage().getName().startsWith(ORG_MULE_TOOLING_CLIENT_API)) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("No need for transformation of typeAnnotation {}", e.getKey());
                        }
                        toTypeAnnotationTransformedMap.put(new TypeAnnotationEntryKey(((TypeAnnotation)e.getValue()).getName()), e.getValue());
                        continue;
                    }
                    LOGGER.warn(String.format("Cannot find a transformer for typeAnnotation %s", e.getKey()));
                    throw new IllegalStateException(String.format("Cannot find a transformer for typeAnnotation %s", e.getKey()));
                }
                source = toTypeAnnotationTransformedMap;
            }
            super.marshal((Object)source, writer, context);
        }

        protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
            reader.moveDown();
            Class<?> key = this.readItem(reader, context, map);
            reader.moveUp();
            Object value = null;
            reader.moveDown();
            if (key instanceof TypeAnnotationEntryKey) {
                String typeId = ((TypeAnnotationEntryKey)key).getTypeId();
                if (TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.containsKey(typeId)) {
                    key = TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.get(typeId);
                } else {
                    LOGGER.debug("Unknown typeId:'{}' when unmarshalling TypeAnnotation", (Object)typeId);
                    key = null;
                }
            }
            if (key != null) {
                value = this.readItem(reader, context, map);
            }
            reader.moveUp();
            if (key != null && value != null) {
                if (toolingTypeAnnotationTransformers.containsKey(key)) {
                    value = toolingTypeAnnotationTransformers.get(key).transform((Object)((TypeAnnotation)value));
                    key = value.getClass();
                }
                target.put(key, value);
            }
        }
    }
}

