/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.CachedExtensionModelService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultExtensionModelService;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClient;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.application.DefaultApplicationService;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;

public class DefaultToolingRuntimeClientBuilder
implements ToolingRuntimeClient.Builder,
Command {
    private MavenClient mavenClient;
    private ModuleRepository moduleRepository;
    private ArtifactClassLoader containerClassLoaderFactory;
    private ExtensionModelServiceCache extensionModelServiceCache;
    private ApplicationCache applicationCache;
    private Optional<MetadataCacheFactory> metadataCacheFactoryOptional = Optional.empty();
    private DslSyntaxServiceCache dslSyntaxServiceCache;
    private AgentConfiguration agentConfiguration;

    public DefaultToolingRuntimeClientBuilder(ModuleRepository moduleRepository, ArtifactClassLoader containerClassLoaderFactory, ExtensionModelServiceCache extensionModelServiceCache, ApplicationCache applicationCache, DslSyntaxServiceCache dslSyntaxServiceCache) {
        this.moduleRepository = moduleRepository;
        this.containerClassLoaderFactory = containerClassLoaderFactory;
        this.extensionModelServiceCache = extensionModelServiceCache;
        this.applicationCache = applicationCache;
        this.dslSyntaxServiceCache = dslSyntaxServiceCache;
    }

    public ToolingRuntimeClient.Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public ToolingRuntimeClient.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenClient = MavenClientProvider.discoverProvider((ClassLoader)DefaultToolingRuntimeClientBuilder.class.getClassLoader()).createMavenClient(mavenConfiguration);
        return this;
    }

    public ToolingRuntimeClient.Builder withMetadataCacheFactory(MetadataCacheFactory metadataCacheFactory) {
        this.metadataCacheFactoryOptional = Optional.ofNullable(metadataCacheFactory);
        return this;
    }

    public ToolingRuntimeClient build() {
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(this.mavenClient, this.moduleRepository, this.containerClassLoaderFactory);
        DefaultExtensionModelService extensionModelService = new DefaultExtensionModelService(this.mavenClient, muleArtifactResourcesRegistry);
        CachedExtensionModelService muleRuntimeExtensionModelProvider = new CachedExtensionModelService(this.extensionModelServiceCache, extensionModelService);
        DefaultApplicationService applicationService = new DefaultApplicationService(muleArtifactResourcesRegistry);
        return new DefaultToolingRuntimeClient(this.mavenClient, Optional.ofNullable(this.agentConfiguration), muleRuntimeExtensionModelProvider, applicationService, this.applicationCache, this.metadataCacheFactoryOptional, this.dslSyntaxServiceCache);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "withRemoteAgentConfiguration": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(AgentConfiguration.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.withRemoteAgentConfiguration((AgentConfiguration)SerializationUtilsImpl.deserialize(arguments[0]));
                return this;
            }
            case "withMavenConfiguration": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(MavenConfiguration.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.withMavenConfiguration((MavenConfiguration)SerializationUtilsImpl.deserialize(arguments[0]));
                return this;
            }
            case "build": {
                return this.build();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

