/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory.AgentTrackingNotificationResponse;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.message.history.MessageHistory;
import org.mule.tooling.client.api.message.history.MessageHistoryService;
import org.mule.tooling.client.api.types.Transaction;
import org.mule.tooling.client.api.types.TransactionStackEntry;
import org.mule.tooling.client.api.types.TransactionStatus;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;
import org.mule.tooling.event.model.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageHistoryService
implements MessageHistoryService,
Command {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FIRST_MESSAGE_PROCESSOR_INDEX = "/0";
    private static final String MESSAGE_PRE_INVOKE_ACTION = "message processor pre invoke";
    private static final String MESSAGE_POST_INVOKE_ACTION = "message processor post invoke";
    private static final String MESSAGE_EXCEPTION = "exception";
    private LazyValue<RuntimeToolingService> runtimeToolingServiceLazyValue;

    protected DefaultMessageHistoryService(LazyValue<RuntimeToolingService> runtimeToolingServiceLazyValue) {
        Objects.requireNonNull(runtimeToolingServiceLazyValue, "runtimeToolingServiceLazyValue cannot be null");
        this.runtimeToolingServiceLazyValue = runtimeToolingServiceLazyValue;
    }

    public void enable(String applicationName) {
        ((RuntimeToolingService)this.runtimeToolingServiceLazyValue.get()).enableMessageHistory(applicationName);
    }

    public MessageHistory consume(String applicationName, int chunkSize) {
        List agentTrackingNotifications = ((RuntimeToolingService)this.runtimeToolingServiceLazyValue.get()).consumeMessageHistoryNotifications(applicationName, chunkSize);
        return this.convertToMessageHistory(agentTrackingNotifications);
    }

    private MessageHistory convertToMessageHistory(List<AgentTrackingNotificationResponse> agentTrackingNotifications) {
        MessageHistory messageHistory = new MessageHistory();
        ArrayList transactions = new ArrayList();
        messageHistory.setTransactions(transactions);
        Map<String, List<AgentTrackingNotificationResponse>> notificationsMap = this.splitAgentNotificationsAndSortByDate(agentTrackingNotifications);
        notificationsMap.keySet().stream().forEach(transactionId -> {
            List transactionNotifications = (List)notificationsMap.get(transactionId);
            Transaction transaction = new Transaction();
            transaction.setTransactionStatus(TransactionStatus.COMPLETE);
            transaction.setId(((AgentTrackingNotificationResponse)transactionNotifications.get(0)).getTransactionId());
            AgentTrackingNotificationResponse firstMessageProcessorInputNotification = (AgentTrackingNotificationResponse)transactionNotifications.get(0);
            if (firstMessageProcessorInputNotification.getComponentLocation().getLocation().endsWith(FIRST_MESSAGE_PROCESSOR_INDEX) && firstMessageProcessorInputNotification.getAction().equals(MESSAGE_PRE_INVOKE_ACTION)) {
                transaction.setMessage(firstMessageProcessorInputNotification.getEvent().getMessage());
                transaction.setTimestamp(firstMessageProcessorInputNotification.getTimestamp());
                transaction.setGlobalName(DefaultMessageHistoryService.getGlobalNameFromLocation(firstMessageProcessorInputNotification.getComponentLocation().getLocation()));
            }
            DefaultMessageHistoryService.markAsUnsuccessfulExceptionResponses(transactionNotifications);
            DefaultMessageHistoryService.markAsUnsuccesfulUnfinishedResponses(transactionNotifications);
            transaction.setTransactionStack(transactionNotifications.stream().filter(agentTrackingNotification -> agentTrackingNotification.getAction().equals(MESSAGE_POST_INVOKE_ACTION)).map(agentTrackingNotification -> {
                TransactionStackEntry transactionStackEntry = new TransactionStackEntry();
                transactionStackEntry.setTimestamp(agentTrackingNotification.getTimestamp());
                transactionStackEntry.setComponentLocation(agentTrackingNotification.getComponentLocation());
                transactionStackEntry.setEventModel(agentTrackingNotification.getEvent());
                return transactionStackEntry;
            }).collect(Collectors.toList()));
            transactions.add(transaction);
        });
        return messageHistory;
    }

    private Map<String, List<AgentTrackingNotificationResponse>> splitAgentNotificationsAndSortByDate(List<AgentTrackingNotificationResponse> agentTrackingNotifications) {
        this.logger.debug("Grouping notifications by correlationId");
        HashMap<String, List<AgentTrackingNotificationResponse>> notificationsMap = new HashMap<String, List<AgentTrackingNotificationResponse>>();
        agentTrackingNotifications.stream().forEach(agentTrackingNotification -> {
            this.logger.debug("Processing notification: {}", agentTrackingNotification);
            ArrayList<AgentTrackingNotificationResponse> notifications = (ArrayList<AgentTrackingNotificationResponse>)notificationsMap.get(agentTrackingNotification.getCorrelationId());
            if (notifications == null) {
                notifications = new ArrayList<AgentTrackingNotificationResponse>();
                notificationsMap.put(agentTrackingNotification.getCorrelationId(), notifications);
            }
            notifications.add((AgentTrackingNotificationResponse)agentTrackingNotification);
        });
        for (List transactinAgentNotifications : notificationsMap.values()) {
            Collections.sort(transactinAgentNotifications, Comparator.comparingLong(AgentTrackingNotificationResponse::getTimestamp));
        }
        return notificationsMap;
    }

    private static Map<String, AgentTrackingNotificationResponse> getPostInvokeNotifications(List<AgentTrackingNotificationResponse> agentTrackingNotificationResponses) {
        return agentTrackingNotificationResponses.stream().filter(notification -> notification.getAction().equals(MESSAGE_POST_INVOKE_ACTION)).collect(Collectors.toMap(notification -> notification.getComponentLocation().getLocation(), Function.identity()));
    }

    private static Map<String, AgentTrackingNotificationResponse> getExceptionNotifications(List<AgentTrackingNotificationResponse> agentTrackingNotificationResponses) {
        return agentTrackingNotificationResponses.stream().filter(notification -> notification.getAction().equals(MESSAGE_EXCEPTION)).collect(Collectors.toMap(AgentTrackingNotificationResponse::getTransactionId, Function.identity()));
    }

    private static void markAsUnsuccessfulExceptionResponses(List<AgentTrackingNotificationResponse> agentTrackingNotificationResponses) {
        ArrayList createdExceptionResponses = new ArrayList();
        Map<String, AgentTrackingNotificationResponse> postInvokeNotifications = DefaultMessageHistoryService.getPostInvokeNotifications(agentTrackingNotificationResponses);
        agentTrackingNotificationResponses.stream().filter(agentTrackingNotificationResponse -> agentTrackingNotificationResponse.getAction().equals(MESSAGE_EXCEPTION)).forEach(exceptionNotificationResponse -> {
            ComponentLocation componentLocation = exceptionNotificationResponse.getComponentLocation();
            if (postInvokeNotifications.containsKey(componentLocation.getLocation())) {
                ((AgentTrackingNotificationResponse)postInvokeNotifications.get(componentLocation.getLocation())).getEvent().setSuccessful(false);
            } else {
                createdExceptionResponses.add(DefaultMessageHistoryService.createResponseFromExceptionEvent(exceptionNotificationResponse));
            }
        });
        agentTrackingNotificationResponses.addAll(createdExceptionResponses);
    }

    private static void markAsUnsuccesfulUnfinishedResponses(List<AgentTrackingNotificationResponse> agentTrackingNotificationResponses) {
        ArrayList createdUnfinishedResponses = new ArrayList();
        Map<String, AgentTrackingNotificationResponse> postInvokeNotifications = DefaultMessageHistoryService.getPostInvokeNotifications(agentTrackingNotificationResponses);
        Map<String, AgentTrackingNotificationResponse> exceptionNotifications = DefaultMessageHistoryService.getExceptionNotifications(agentTrackingNotificationResponses);
        agentTrackingNotificationResponses.stream().filter(agentTrackingNotificationResponse -> agentTrackingNotificationResponse.getAction().equals(MESSAGE_PRE_INVOKE_ACTION)).forEach(agentTrackingNotificationResponse -> {
            if (postInvokeNotifications.containsKey(agentTrackingNotificationResponse.getComponentLocation().getLocation())) {
                return;
            }
            String transactionID = agentTrackingNotificationResponse.getTransactionId();
            if (exceptionNotifications.containsKey(transactionID)) {
                AgentTrackingNotificationResponse errorResponse = DefaultMessageHistoryService.createResponseFromExceptionEvent((AgentTrackingNotificationResponse)exceptionNotifications.get(transactionID));
                errorResponse.setComponentLocation(agentTrackingNotificationResponse.getComponentLocation());
                createdUnfinishedResponses.add(errorResponse);
            }
        });
        agentTrackingNotificationResponses.addAll(createdUnfinishedResponses);
    }

    private static AgentTrackingNotificationResponse createResponseFromExceptionEvent(AgentTrackingNotificationResponse exceptionNotificationResponse) {
        AgentTrackingNotificationResponse response = new AgentTrackingNotificationResponse();
        response.setAction(MESSAGE_POST_INVOKE_ACTION);
        response.setComponentLocation(exceptionNotificationResponse.getComponentLocation());
        response.setEvent(exceptionNotificationResponse.getEvent());
        response.setTimestamp(exceptionNotificationResponse.getTimestamp());
        return response;
    }

    private static String getGlobalNameFromLocation(String location) {
        return Location.builderFromStringRepresentation((String)location).build().getGlobalName();
    }

    public void disable(String applicationName) {
        try {
            ((RuntimeToolingService)this.runtimeToolingServiceLazyValue.get()).disableMessageHistory(applicationName);
        }
        catch (Exception e) {
            this.logger.warn("Error while disabling application for try it", (Throwable)e);
        }
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "enable": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.enable((String)SerializationUtilsImpl.deserialize(arguments[0]));
                return null;
            }
            case "consume": {
                Preconditions.checkState((arguments.length == 2 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 2 && classes[0].equals(String.class.getName()) && classes[1].equals(Integer.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return SerializationUtilsImpl.serialize(this.consume((String)SerializationUtilsImpl.deserialize(arguments[0]), (Integer)SerializationUtilsImpl.deserialize(arguments[1])));
            }
            case "disable": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.disable((String)SerializationUtilsImpl.deserialize(arguments[0]));
                return null;
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

