/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.exception.ToolingArtifactNotFoundException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.message.history.MessageHistoryService;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultMessageHistoryService;
import org.mule.tooling.client.internal.DefaultToolingArtifact;
import org.mule.tooling.client.internal.DefaultToolingArtifactContext;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.NoOpMetadataCache;
import org.mule.tooling.client.internal.ToolingArtifactWrapper;
import org.mule.tooling.client.internal.ToolingExtensionModelAdapter;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.ApplicationService;
import org.mule.tooling.client.internal.application.DefaultApplication;
import org.mule.tooling.client.internal.artifact.DefaultArtifactSerializationService;
import org.mule.tooling.client.internal.dsl.DefaultDslSyntaxResolverService;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;

public class DefaultToolingRuntimeClient
implements ToolingRuntimeClient,
Command {
    private DefaultToolingArtifactContext context;
    private ExtensionModelService extensionModelService;
    private ArtifactSerializationService artifactSerializationService;
    private DslSyntaxResolverService dslSyntaxResolverService;
    private MessageHistoryService messageHistoryService;

    public DefaultToolingRuntimeClient(MavenClient mavenClient, Optional<AgentConfiguration> agentConfigurationOptional, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, ApplicationService applicationService, ApplicationCache applicationCache, Optional<MetadataCacheFactory> metadataCacheFactoryOptional, DslSyntaxServiceCache dslSyntaxServiceCache) {
        com.google.common.base.Preconditions.checkNotNull((Object)mavenClient, (Object)"aetherDependencyResolver cannot be null");
        com.google.common.base.Preconditions.checkNotNull(agentConfigurationOptional, (Object)"agentConfigurationOptional cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)muleRuntimeExtensionModelProvider, (Object)"muleRuntimeExtensionModelProvider cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)applicationService, (Object)"applicationService cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)applicationCache, (Object)"applicationCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull(metadataCacheFactoryOptional, (Object)"metadataCacheFactoryOptional cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)dslSyntaxServiceCache, (Object)"dslSyntaxServiceCache cannot be null");
        this.context = new DefaultToolingArtifactContext();
        this.context.setAgentConfiguration(agentConfigurationOptional);
        this.context.setMavenClient(mavenClient);
        this.context.setMuleRuntimeExtensionModelProvider(muleRuntimeExtensionModelProvider);
        this.context.setApplicationService(applicationService);
        this.context.setApplicationCache(applicationCache);
        this.context.setMetadataCacheFactory(metadataCacheFactoryOptional);
        this.extensionModelService = new ToolingExtensionModelAdapter(muleRuntimeExtensionModelProvider);
        this.artifactSerializationService = new DefaultArtifactSerializationService(muleRuntimeExtensionModelProvider.getRuntimeExtensionModels(), muleRuntimeExtensionModelProvider, mavenClient);
        this.messageHistoryService = new DefaultMessageHistoryService((LazyValue<RuntimeToolingService>)new LazyValue(() -> this.context.getRuntimeToolingService()));
        this.extensionModelService = new ToolingExtensionModelAdapter(muleRuntimeExtensionModelProvider);
        this.dslSyntaxResolverService = new DefaultDslSyntaxResolverService(dslSyntaxServiceCache, mavenClient, muleRuntimeExtensionModelProvider);
    }

    public ExtensionModelService extensionModelService() {
        return this.extensionModelService;
    }

    public ArtifactSerializationService artifactSerializationService() {
        return this.artifactSerializationService;
    }

    public DslSyntaxResolverService dslSyntaxResolverService() {
        return this.dslSyntaxResolverService;
    }

    public MessageHistoryService messageHistoryService() {
        return this.messageHistoryService;
    }

    public ToolingArtifact newToolingArtifact(URL applicationUrlContent, Map<String, String> properties) {
        String id = UUID.randomUUID().toString();
        ApplicationCache applicationCache = this.context.getApplicationCache();
        Application application = applicationCache.getApplication(id, () -> new DefaultApplication(applicationUrlContent, this.context, properties));
        MetadataCache metadataCache = this.context.getMetadataCacheFactory().map(factory -> factory.createMetadataCache(id, applicationUrlContent, application.getProperties())).orElse(NoOpMetadataCache.INSTANCE);
        return this.newToolingArtifact(id, applicationCache, metadataCache, application);
    }

    public ToolingArtifact fetchToolingArtifact(String id) throws ToolingArtifactNotFoundException {
        Application application = this.context.getApplicationCache().getApplication(id, () -> {
            throw new ToolingArtifactNotFoundException(String.format("ToolingArtifact not found in cache for id: %s", id));
        });
        MetadataCache metadataCache = this.context.getMetadataCacheFactory().map(factory -> factory.createMetadataCache(id, application.getApplicationUrlContent(), application.getProperties())).orElse(NoOpMetadataCache.INSTANCE);
        application.setContext(this.context);
        return this.newToolingArtifact(id, this.context.getApplicationCache(), metadataCache, application);
    }

    private ToolingArtifact newToolingArtifact(final String id, final ApplicationCache applicationCache, MetadataCache metadataCache, Application application) {
        return new ToolingArtifactWrapper(new DefaultToolingArtifact(id, metadataCache, application){

            @Override
            public void dispose() {
                applicationCache.invalidate(id);
            }
        });
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "messageHistoryService": {
                return this.messageHistoryService();
            }
            case "extensionModelService": {
                return this.extensionModelService();
            }
            case "artifactSerializationService": {
                return this.artifactSerializationService();
            }
            case "dslSyntaxResolverService": {
                return this.dslSyntaxResolverService();
            }
            case "newToolingArtifact": {
                Preconditions.checkState((arguments.length == 2 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 2 && classes[0].equals(URL.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 2 && classes[1].equals(Map.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.newToolingArtifact((URL)SerializationUtilsImpl.deserialize(arguments[0]), (Map)SerializationUtilsImpl.deserialize(arguments[1]));
            }
            case "fetchToolingArtifact": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.fetchToolingArtifact((String)SerializationUtilsImpl.deserialize(arguments[0]));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

