/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import static java.util.Optional.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;
import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import static org.mule.tooling.client.api.extension.model.PathModelLocation.embeddedPathModelLocation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.tooling.client.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.PathModel;
import org.mule.tooling.client.api.extension.model.PathModelType;

import org.junit.Test;

public class TypeAnnotationsSerializationTestCase {

  @Test
  public void displayTypeAnnotation() {
    final DisplayModel displayModel = new DisplayModel("displayName",
                                                       "summary",
                                                       "example",
                                                       new PathModel(
                                                                     PathModelType.anyPathModelType("ANY"),
                                                                     true,
                                                                     embeddedPathModelLocation("EMBEDDED"),
                                                                     new String[] {"txt"}));
    StringType stringType = new BaseTypeBuilder(JAVA)
        .stringType()
        .with(new DisplayTypeAnnotation(displayModel))
        .build();

    XStreamServerSerializer serializer = new XStreamServerSerializer();
    String xml = serializer.serialize(stringType);
    MetadataType deserialized = XStreamServerSerializer.deserialize(xml);

    assertThat(deserialized.getAnnotation(org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation.class),
               not(
                   empty()));


    final org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation displayTypeAnnotation =
        deserialized.getAnnotation(org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation.class).get();

    assertThat(displayTypeAnnotation.getDisplayName(), equalTo(displayModel.getDisplayName()));
    assertThat(displayTypeAnnotation.getExample(), equalTo(displayModel.getExample()));
    assertThat(displayTypeAnnotation.getSummary(), equalTo(displayModel.getSummary()));
    assertThat(displayTypeAnnotation.getPathModel(), not(empty()));
    assertThat(displayTypeAnnotation.getPathModel().get().getFileExtensions(),
               equalTo(displayModel.getPathModel().get().getFileExtensions()));
    assertThat(displayTypeAnnotation.getPathModel().get().getType().name(),
               equalTo(displayModel.getPathModel().get().getType().getValue()));
  }

}
