/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.ImmutableMetadataResult;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.internal.LocationFactory;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.serialization.XStreamFactory;

public class DataSenseMetadataCacheAdapter
implements DataSenseMetadataCacheProvider {
    private MetadataCache metadataCache;
    private Map<String, String> toolingArtifactProperties;
    private XStream xStream;

    public DataSenseMetadataCacheAdapter(MetadataCache metadataCache, Map<String, String> toolingArtifactProperties) {
        this.metadataCache = metadataCache;
        this.toolingArtifactProperties = toolingArtifactProperties;
        this.xStream = XStreamFactory.createXStream();
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String componentId, Location location, Long timestamp, Callable<MetadataResult<ComponentMetadataDescriptor<OperationModel>>> callable) {
        String result = (String)((Object)this.metadataCache.getOperationMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, this.toolingArtifactProperties), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.xStream.toXML((Object)runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.xStream.fromXML(result);
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String componentId, Location location, Long timestamp, Callable<MetadataResult<ComponentMetadataDescriptor<SourceModel>>> callable) {
        String result = (String)((Object)this.metadataCache.getSourceMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, this.toolingArtifactProperties), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.xStream.toXML((Object)runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.xStream.fromXML(result);
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(String componentId, Location location, Long timestamp, Callable<MetadataResult<MetadataKeysContainer>> callable) {
        String result = (String)((Object)this.metadataCache.getMetadataKeys((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, this.toolingArtifactProperties), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.xStream.toXML((Object)runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.xStream.fromXML(result);
    }
}

