/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultConnectivityTestingService;
import org.mule.tooling.client.internal.DefaultDataSenseService;
import org.mule.tooling.client.internal.DefaultValueProviderService;
import org.mule.tooling.client.internal.InternalMetadataProvider;
import org.mule.tooling.client.internal.ToolingMetadataServiceAdapter;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunnerProvider;
import org.mule.tooling.client.internal.dataweave.DefaultDataWeaveService;
import org.mule.tooling.client.internal.dataweave.LocalRunner;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.dataweave.RemoteRunner;
import org.mule.tooling.client.internal.serialization.XStreamServerSerializer;

public class DefaultToolingArtifact
implements ToolingArtifact,
Command {
    private String id;
    private Application application;
    private ConnectivityTestingService connectivityTestingService;
    private MetadataService metadataService;
    private DataSenseService dataSenseService;
    private DataWeaveService dataWeaveService;
    private ValueProviderService valueProviderService;

    public DefaultToolingArtifact(String id, MetadataCache metadataCache, Application application) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)application, (Object)"application cannot be null");
        Preconditions.checkNotNull((Object)metadataCache, (Object)"metadataCache cannot be null");
        this.id = id;
        this.application = application;
        this.connectivityTestingService = new DefaultConnectivityTestingService(application);
        InternalMetadataProvider metadataProvider = new InternalMetadataProvider(application);
        this.metadataService = new ToolingMetadataServiceAdapter(application, metadataProvider, metadataCache);
        this.dataSenseService = new DefaultDataSenseService(application, metadataProvider, metadataCache);
        RemoteRunner remoteRunner = new RemoteRunner(application);
        LocalRunner localRunner = new LocalRunner(application);
        this.dataWeaveService = new DefaultDataWeaveService(application, new DataWeaveRunnerProvider(localRunner, remoteRunner), new ModulesAnalyzer());
        this.valueProviderService = new DefaultValueProviderService(application);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getProperties() {
        return this.application.getProperties();
    }

    public ConnectivityTestingService connectivityTestingService() {
        return this.connectivityTestingService;
    }

    public MetadataService metadataService() {
        return this.metadataService;
    }

    public DataSenseService dataSenseService() {
        return this.dataSenseService;
    }

    public DataWeaveService dataWeaveService() {
        return this.dataWeaveService;
    }

    public ValueProviderService valueProviderService() {
        return this.valueProviderService;
    }

    public void dispose() {
        this.application.dispose();
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "id": {
                return XStreamServerSerializer.serialize(this.getId());
            }
            case "connectivityTestingService": {
                return this.connectivityTestingService();
            }
            case "metadataService": {
                return this.metadataService();
            }
            case "dataSenseService": {
                return this.dataSenseService();
            }
            case "dataWeaveService": {
                return this.dataWeaveService();
            }
            case "valueProviderService": {
                return this.valueProviderService();
            }
            case "dispose": {
                this.dispose();
                return null;
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

