/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.serialization.XStreamFactory;

public class MetadataCacheProxy
implements MetadataCache {
    private Object proxyTarget;
    private XStream xStream;
    private Object proxyXstream;

    public MetadataCacheProxy(Object proxyTarget) {
        Objects.requireNonNull(proxyTarget, "proxyTarget cannot be null");
        this.proxyTarget = proxyTarget;
        this.xStream = XStreamFactory.createXStream();
        this.xStream.ignoreUnknownElements();
        try {
            this.proxyXstream = proxyTarget.getClass().getClassLoader().loadClass(XStreamFactory.class.getName()).getMethod("createXStream", new Class[0]).invoke(null, new Object[0]);
            this.proxyXstream.getClass().getMethod("ignoreUnknownElements", new Class[0]).invoke(this.proxyXstream, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating proxy for XStream with clients class loader", e);
        }
    }

    public Serializable invoke(String methodName, String componentId, String location, Long timestamp, Map<String, String> toolingArtifactProperties, Callable callable) {
        try {
            Method method = this.proxyTarget.getClass().getMethod(methodName, this.proxyTarget.getClass().getClassLoader().loadClass(MetadataCache.MetadataCacheKeyInfo.class.getName()), Callable.class);
            method.setAccessible(true);
            CallableProxy proxyCallable = new CallableProxy(callable);
            return (Serializable)method.invoke(this.proxyTarget, this.createMetadataCacheKeyInfo(componentId, location, timestamp, toolingArtifactProperties), proxyCallable);
        }
        catch (Exception e) {
            throw new ToolingException("Error while calling proxy method on client code", (Throwable)e);
        }
    }

    private Object createMetadataCacheKeyInfo(String componentId, String location, Long timestamp, Map<String, String> toolingArtifactProperties) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ClassLoader classLoader = this.proxyTarget.getClass().getClassLoader();
        return classLoader.loadClass(ImmutableMetadataCacheKeyInfo.class.getName()).getConstructor(String.class, String.class, Long.class, Map.class).newInstance(componentId, location, timestamp, toolingArtifactProperties);
    }

    public Serializable getOperationMetadata(MetadataCache.MetadataCacheKeyInfo metadataCacheKeyInfo, Callable resolver) {
        return this.invoke("getOperationMetadata", metadataCacheKeyInfo.getComponentId(), metadataCacheKeyInfo.getLocation(), metadataCacheKeyInfo.getTimestamp(), metadataCacheKeyInfo.getToolingArtifactProperties(), resolver);
    }

    public Serializable getSourceMetadata(MetadataCache.MetadataCacheKeyInfo metadataCacheKeyInfo, Callable<MetadataCache.MetadataResult> resolver) {
        return this.invoke("getSourceMetadata", metadataCacheKeyInfo.getComponentId(), metadataCacheKeyInfo.getLocation(), metadataCacheKeyInfo.getTimestamp(), metadataCacheKeyInfo.getToolingArtifactProperties(), resolver);
    }

    public Serializable getMetadataKeys(MetadataCache.MetadataCacheKeyInfo metadataCacheKeyInfo, Callable<MetadataCache.MetadataResult> resolver) {
        return this.invoke("getMetadataKeys", metadataCacheKeyInfo.getComponentId(), metadataCacheKeyInfo.getLocation(), metadataCacheKeyInfo.getTimestamp(), metadataCacheKeyInfo.getToolingArtifactProperties(), resolver);
    }

    private class CallableProxy
    implements Callable {
        private Callable proxyTarget;

        public CallableProxy(Callable proxyTarget) {
            this.proxyTarget = proxyTarget;
        }

        public Object call() throws Exception {
            Object result = this.proxyTarget.call();
            String xml = MetadataCacheProxy.this.xStream.toXML(result);
            return MetadataCacheProxy.this.proxyXstream.getClass().getMethod("fromXML", String.class).invoke(MetadataCacheProxy.this.proxyXstream, xml);
        }
    }
}

