/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.datasense.enrichment.model.IdComponentModelSelector;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.ImmutableMetadataResult;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.serialization.XStreamFactory;
import org.mule.tooling.client.internal.serialization.XStreamServerSerializer;

public class ToolingMetadataServiceAdapter
implements MetadataService,
Command {
    private Application application;
    private MetadataProvider metadataProvider;
    private MetadataCache metadataCache;
    private XStream xStream;

    public ToolingMetadataServiceAdapter(Application application, MetadataProvider metadataProvider, MetadataCache metadataCache) {
        com.google.common.base.Preconditions.checkNotNull((Object)application, (Object)"application cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)metadataCache, (Object)"metadataCache cannot be null");
        this.application = application;
        this.metadataProvider = metadataProvider;
        this.metadataCache = metadataCache;
        this.xStream = XStreamFactory.createXStream();
    }

    public org.mule.tooling.client.api.metadata.MetadataResult<org.mule.tooling.client.api.metadata.MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException {
        MetadataResult metadataKeys;
        ApplicationModel applicationModel = this.application.getApplicationModel();
        Optional<ComponentModel> componentModel = this.findComponentModel(applicationModel, metadataKeysRequest.getLocation());
        if (!componentModel.isPresent()) {
            metadataKeys = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("No object found at location %s", metadataKeysRequest.getLocation().toString())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onKeys()});
        } else {
            String componentId = IdComponentModelSelector.getComponentId((ComponentModel)componentModel.get());
            metadataKeys = (MetadataResult)this.xStream.fromXML((String)((Object)this.metadataCache.getMetadataKeys((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, metadataKeysRequest.getLocation().toString(), null, this.application.getProperties()), () -> {
                MetadataResult<MetadataKeysContainer> runtimeMetadataResult = this.metadataProvider.getMetadataKeys(metadataKeysRequest);
                List<Object> failures = Collections.emptyList();
                if (!runtimeMetadataResult.isSuccess()) {
                    failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
                }
                return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.xStream.toXML(runtimeMetadataResult)), failures);
            })));
        }
        return MetadataPartsFactory.toMetadataResultDTO(metadataKeys, () -> MetadataPartsFactory.toMetadataKeysContainerDTO((MetadataKeysContainer)metadataKeys.get()));
    }

    private Optional<ComponentModel> findComponentModel(ApplicationModel applicationModel, Location location) {
        Reference foundComponentModelReference = new Reference();
        Optional globalComponent = applicationModel.findTopLevelNamedComponent(location.getGlobalName());
        globalComponent.ifPresent(componentModel -> this.findComponentWithLocation((ComponentModel)componentModel, location).ifPresent(foundComponentModel -> {
            ComponentModel cfr_ignored_0 = (ComponentModel)foundComponentModelReference.set(foundComponentModel);
        }));
        return Optional.ofNullable(foundComponentModelReference.get());
    }

    private Optional<ComponentModel> findComponentWithLocation(ComponentModel componentModel, Location location) {
        if (componentModel.getComponentLocation().getLocation().equals(location.toString())) {
            return Optional.of(componentModel);
        }
        for (ComponentModel childComponent : componentModel.getInnerComponents()) {
            Optional<ComponentModel> foundComponent = this.findComponentWithLocation(childComponent, location);
            if (!foundComponent.isPresent()) continue;
            return foundComponent;
        }
        return Optional.empty();
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getMetadataKeys": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(MetadataKeysRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return XStreamServerSerializer.serialize(this.getMetadataKeys((MetadataKeysRequest)XStreamServerSerializer.deserialize(arguments[0])));
            }
        }
        throw new IllegalArgumentException(String.format("Invalid arguments passed for calling method '%s' on '%s'", methodName, this.getClass()));
    }
}

