/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.application.AbstractApplicationDeployer;

public class FileSystemApplicationDeployer
extends AbstractApplicationDeployer {
    public FileSystemApplicationDeployer(URL applicationUrl, RuntimeToolingService runtimeToolingService) {
        super(applicationUrl, runtimeToolingService);
    }

    @Override
    protected String doInternalInit(URL applicationUrlContent, RuntimeToolingService runtimeToolingService) {
        String applicationId;
        File appLocation;
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Deploying application from URL: {}", (Object)applicationUrlContent);
        }
        Preconditions.checkArgument(((appLocation = FileUtils.toFile((URL)applicationUrlContent)) != null && appLocation.exists() ? 1 : 0) != 0, (Object)("applicationUrl: " + applicationUrlContent + " is invalid"));
        if (appLocation.isDirectory()) {
            applicationId = runtimeToolingService.deployApplication(appLocation);
        } else if (appLocation.isFile()) {
            try {
                applicationId = runtimeToolingService.deployApplication((InputStream)new FileInputStream(appLocation));
            }
            catch (IOException e) {
                throw new ToolingException("Couldn't create inputStream for zip file from application URL: " + applicationUrlContent);
            }
        } else {
            throw new IllegalArgumentException("Couldn't handle URL for deploying application: " + applicationUrlContent);
        }
        return applicationId;
    }
}

