/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import com.mulesoft.agent.domain.tooling.dataweave.model.Event;
import com.mulesoft.agent.domain.tooling.dataweave.model.Message;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;
import com.mulesoft.agent.domain.tooling.dataweave.model.TypedValue;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunner;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;

public class RemoteRunner
implements DataWeaveRunner {
    private RemoteApplicationInvoker remoteApplicationInvoker;

    public RemoteRunner(RemoteApplicationInvoker remoteApplicationInvoker) {
        Objects.requireNonNull(remoteApplicationInvoker, "remoteApplicationInvoker cannot be null");
        this.remoteApplicationInvoker = remoteApplicationInvoker;
    }

    @Override
    public DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters) {
        PreviewRequest request = this.toAgentPreviewRequest(parameters);
        PreviewResponse response = this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.runDataWeave(applicationId, request));
        return this.toDataWeavePreviewResponse(response);
    }

    private DataWeavePreviewResponse toDataWeavePreviewResponse(PreviewResponse response) {
        return DataWeavePreviewResponse.builder().result(response.getResult()).mediaType(response.getMediaType()).valid(Boolean.valueOf(response.isValid())).errorMessage(response.getErrorMessage()).build();
    }

    private PreviewRequest toAgentPreviewRequest(DataWeavePreviewRequest parameters) {
        PreviewRequest request = new PreviewRequest();
        request.setScript(parameters.getScript());
        EventModel parametersEvent = parameters.getEvent();
        if (parametersEvent != null) {
            Event event = new Event();
            this.toAgentMessage(parametersEvent, event);
            this.toAgentVariables(parametersEvent, event);
            request.setEvent(event);
        }
        return request;
    }

    private void toAgentVariables(EventModel parametersEvent, Event event) {
        Map parametersVariables = parametersEvent.getVariables();
        if (parametersVariables != null && !parametersVariables.isEmpty()) {
            HashMap variables = new HashMap();
            parametersVariables.forEach((s, typedValueModel) -> {
                if (typedValueModel != null) {
                    variables.put(s, this.toAgentTypedValue((TypedValueModel)typedValueModel));
                }
            });
            event.setVariables(variables);
        }
    }

    private TypedValue toAgentTypedValue(TypedValueModel typedValueModel) {
        TypedValue value = new TypedValue();
        String mediaType = typedValueModel.getDataType().getMediaType();
        MediaType parse = MediaType.parse((String)mediaType);
        value.setValue(new String(typedValueModel.getContent(), parse.getCharset().orElseGet(Charset::defaultCharset)));
        value.setMediaType(mediaType);
        return value;
    }

    private void toAgentMessage(EventModel parametersEvent, Event event) {
        MessageModel parametersMessage = parametersEvent.getMessage();
        if (parametersMessage != null) {
            Message message = new Message();
            if (parametersMessage.getPayload() != null) {
                message.setPayload(this.toAgentTypedValue(parametersMessage.getPayload()));
            }
            if (parametersMessage.getAttributes() != null) {
                message.setAttributes(this.toAgentTypedValue(parametersMessage.getAttributes()));
            }
            event.setMessage(message);
        }
    }
}

