/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.log4j;

import java.net.URI;
import java.util.Objects;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;

public class ToolingLog4jContextFactory
extends Log4jContextFactory
implements Disposable,
ShutdownCallbackRegistry {
    private final ContextSelector selector;

    public ToolingLog4jContextFactory() {
        this(ToolingLog4jContextFactory.createToolingContextSelector(), ToolingLog4jContextFactory.createShutdownCallbackRegistry());
    }

    private ToolingLog4jContextFactory(ContextSelector selector, ShutdownCallbackRegistry shutdownCallbackRegistry) {
        super(selector, shutdownCallbackRegistry);
        this.selector = Objects.requireNonNull(selector, "No ContextSelector provided");
    }

    private static ContextSelector createToolingContextSelector() {
        return new ClassLoaderContextSelector(){

            public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
                if (loader instanceof ArtifactClassLoader) {
                    return this.getDefault();
                }
                return super.getContext(fqcn, loader, currentContext);
            }

            public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
                if (loader instanceof ArtifactClassLoader) {
                    return this.getDefault();
                }
                return super.getContext(fqcn, loader, currentContext, configLocation);
            }
        };
    }

    private static ShutdownCallbackRegistry createShutdownCallbackRegistry() {
        return callback -> new Cancellable(){

            public void cancel() {
            }

            public void run() {
            }
        };
    }

    public void dispose() {
        this.selector.getLoggerContexts().forEach(loggerContext -> {
            if (loggerContext != null && !loggerContext.isStopping() && !loggerContext.isStopped()) {
                loggerContext.stop();
            }
        });
    }

    public Cancellable addShutdownCallback(Runnable callback) {
        return null;
    }
}

