/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.internal.application.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationCache
implements Disposable {
    private static final String TOOLING_CLIENT_APPLICATION_CACHE_EXPIRE_AFTER_ACCESS = "tooling.client.ApplicationCache.expireAfterAccess";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationCache.class);
    private Cache<String, Application> applicationsById = CacheBuilder.newBuilder().expireAfterAccess(Long.valueOf(System.getProperty("tooling.client.ApplicationCache.expireAfterAccess", "300")).longValue(), TimeUnit.SECONDS).removalListener(notification -> ((Application)notification.getValue()).dispose()).build();

    public ApplicationCache() {
        LOGGER.info("Initialising Application cache");
    }

    public Application getApplication(String id, Callable<Application> callable) {
        try {
            return (Application)this.applicationsById.get((Object)id, callable);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void invalidate(String id) {
        this.applicationsById.invalidate((Object)id);
    }

    public void dispose() {
        LOGGER.info("Disposing Application cache");
        this.applicationsById.invalidateAll();
    }
}

