/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.lang.String.format;
import static org.mule.runtime.api.util.Preconditions.checkState;
import static org.mule.tooling.client.internal.Command.methodNotFound;
import static org.mule.tooling.client.internal.serialization.SerializationUtilsImpl.deserialize;
import static org.mule.tooling.client.internal.serialization.SerializationUtilsImpl.serialize;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;

/**
 * Base class for implementing {@link ConnectivityTestingService}.
 *
 * @since 4.0
 */
public abstract class AbstractConnectivityTestingService implements ConnectivityTestingService, Command {

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectionValidationResult testConnection(ConnectivityTestingRequest connectivityTestingRequest)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
    return doTestConnection(connectivityTestingRequest);
  }

  protected abstract ConnectionValidationResult doTestConnection(ConnectivityTestingRequest connectivityTestingRequest);

  @Override
  public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
    switch (methodName) {
      case "testConnection": {
        checkState(arguments.length == 1,
                   format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
        checkState(classes.length == 1 && classes[0].equals(ConnectivityTestingRequest.class.getName()),
                   format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
        return serialize(testConnection(deserialize(arguments[0])));
      }
    }
    throw methodNotFound(this.getClass(), methodName);
  }
}
