/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;

/**
 * Domain implementation for {@link ConnectivityTestingService}.
 *
 * @since 4.0
 */
public class DomainConnectivityTestingService extends AbstractConnectivityTestingService {

  private RemoteDomainInvoker remoteDomainInvoker;

  /**
   * Creates an instance of the service.
   *
   * @param remoteDomainInvoker {@link RemoteDomainInvoker} to deploy and resolve operations against a Mule Runtime. Non null.
   */
  public DomainConnectivityTestingService(RemoteDomainInvoker remoteDomainInvoker) {
    requireNonNull(remoteDomainInvoker, "remoteDomainInvoker cannot be null");

    this.remoteDomainInvoker = remoteDomainInvoker;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ConnectionValidationResult doTestConnection(ConnectivityTestingRequest connectivityTestingRequest) {
    return remoteDomainInvoker
        .evaluateWithRemoteDomain((domainId, runtimeToolingService) -> runtimeToolingService
            .testConnectionDomain(domainId,
                                  connectivityTestingRequest.getComponentId(), connectivityTestingRequest.getRequestTimeout()));
  }

}
