/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPluginDescriptorsResolver;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.internal.application.ApplicationClassLoaderFactory;
import org.mule.tooling.client.internal.application.DomainClassLoaderFactory;

import java.util.Optional;

/**
 * Context for {@link org.mule.tooling.client.api.artifact.ToolingArtifact}.
 */
public interface ToolingArtifactContext {

  /**
   * @return the Mule Plugin Agent configuration.
   */
  Optional<AgentConfiguration> getAgentConfiguration();

  /**
   * @return the {@link RuntimeToolingService} if there was a Mule Plugin Agent configuration set.
   */
  RuntimeToolingService getRuntimeToolingService();

  /**
   * @return the {@link ApplicationCache} for this context.
   */
  ApplicationCache getApplicationCache();

  /**
   * @return the {@link DomainCache} for this context.
   */
  DomainCache getDomainCache();

  /**
   * @return the {@link MavenClient} for this context.
   */
  MavenClient getMavenClient();

  /**
   * @return the {@link MuleRuntimeExtensionModelProvider} for this context.
   */
  MuleRuntimeExtensionModelProvider getMuleRuntimeExtensionModelProvider();

  /**
   * @return the {@link DomainClassLoaderFactory} for this context.
   */
  DomainClassLoaderFactory getDomainClassLoaderFactory();

  /**
   * @return the {@link ApplicationClassLoaderFactory} for this context.
   */
  ApplicationClassLoaderFactory getApplicationClassLoaderFactory();

  /**
   * @return {@link ApplicationPluginDescriptorsResolver} to resolve plugins descriptors for an application.
   */
  ApplicationPluginDescriptorsResolver getApplicationPluginDescriptorsResolver();

}
