/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;

import java.util.Map;
import java.util.Optional;

/**
 * Wrapper for {@link ToolingArtifact}.
 */
public class ToolingArtifactWrapper implements ToolingArtifact, Command {

  private DefaultToolingArtifact delegate;

  public ToolingArtifactWrapper(DefaultToolingArtifact delegate) {
    this.delegate = delegate;
  }

  @Override
  public String getId() {
    return delegate.getId();
  }

  @Override
  public Optional<ToolingArtifact> getParent() {
    return delegate.getParent();
  }

  @Override
  public Map<String, String> getProperties() {
    return delegate.getProperties();
  }

  @Override
  public ConnectivityTestingService connectivityTestingService() {
    return delegate.connectivityTestingService();
  }

  @Override
  public MetadataService metadataService() {
    return delegate.metadataService();
  }

  @Override
  public DataWeaveService dataWeaveService() {
    return delegate.dataWeaveService();
  }

  @Override
  public ValueProviderService valueProviderService() {
    return delegate.valueProviderService();
  }

  @Override
  public DataSenseService dataSenseService() {
    return delegate.dataSenseService();
  }

  @Override
  public void dispose() {
    delegate.dispose();
  }

  @Override
  public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
    return delegate.invokeMethod(methodName, classes, arguments);
  }
}
