/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.lang.String.format;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.tooling.client.api.datasense.DataSenseComponentInfo;
import org.mule.tooling.client.api.datasense.DataSenseInfo;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.api.datasense.DataSenseService;

import java.util.Optional;

/**
 * Implementation for {@link DataSenseService} that throws an {@link IllegalStateException}.
 *
 * @since 4.1.
 */
public class UnavailableDataSenseService extends DefaultDataSenseService {

  private ArtifactType artifactType;

  public UnavailableDataSenseService(ArtifactType artifactType) {
    this.artifactType = artifactType;
  }

  @Override
  public Optional<DataSenseInfo> resolveDataSense(DataSenseRequest dataSenseRequest) {
    throw newIllegalStateException();
  }

  @Override
  public Optional<DataSenseComponentInfo> resolveComponentDataSense(DataSenseRequest dataSenseRequest) {
    throw newIllegalStateException();
  }

  private IllegalStateException newIllegalStateException() {
    return new IllegalStateException(format("DataSense cannot be calculated for artifact: %s", artifactType));
  }

}
