/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.codehaus.plexus.util.ExceptionUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.tooling.client.api.value.ValueResult;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;

public abstract class AbstractValueProviderService
implements ValueProviderService,
Command {
    private static final String DEPLOYMENT = "DEPLOYMENT";

    public ValueResult getValues(ValueProviderRequest valueProviderRequest) {
        try {
            return AbstractValueProviderService.toValueResultDTO(this.doGetValue(valueProviderRequest));
        }
        catch (Exception e) {
            return AbstractValueProviderService.toFailureValueResultDTO(e);
        }
    }

    protected abstract org.mule.runtime.api.value.ValueResult doGetValue(ValueProviderRequest var1);

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getValues": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(ValueProviderRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                ValueProviderRequest valueProviderRequest = (ValueProviderRequest)SerializationUtilsImpl.deserialize(arguments[0]);
                return SerializationUtilsImpl.serialize(this.getValues(valueProviderRequest));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }

    private static ValueResult toValueResultDTO(org.mule.runtime.api.value.ValueResult valueResult) {
        HashSet<org.mule.tooling.client.api.value.Value> values = new HashSet<org.mule.tooling.client.api.value.Value>();
        for (Value value : valueResult.getValues()) {
            values.add(AbstractValueProviderService.toValueDTO(value));
        }
        return new ValueResult(values, AbstractValueProviderService.toResolvingFailureDTO(valueResult.getFailure()));
    }

    private static org.mule.tooling.client.api.value.Value toValueDTO(Value value) {
        HashSet<org.mule.tooling.client.api.value.Value> children = new HashSet<org.mule.tooling.client.api.value.Value>();
        for (Value child : value.getChilds()) {
            children.add(AbstractValueProviderService.toValueDTO(child));
        }
        return new org.mule.tooling.client.api.value.Value(value.getId(), value.getDisplayName(), value.getPartName(), children);
    }

    private static org.mule.tooling.client.api.value.ResolvingFailure toResolvingFailureDTO(Optional<ResolvingFailure> resolvingFailureOptional) {
        if (!resolvingFailureOptional.isPresent()) {
            return null;
        }
        ResolvingFailure resolvingFailure = resolvingFailureOptional.get();
        return new org.mule.tooling.client.api.value.ResolvingFailure(resolvingFailure.getMessage(), resolvingFailure.getReason(), resolvingFailure.getFailureCode());
    }

    private static ValueResult toFailureValueResultDTO(Throwable t) {
        String failureCode = "UNKNOWN";
        if (t instanceof CompletionException && t.getCause() instanceof DeploymentException) {
            failureCode = DEPLOYMENT;
        }
        return new ValueResult(Collections.emptySet(), new org.mule.tooling.client.api.value.ResolvingFailure(t.getMessage(), ExceptionUtils.getStackTrace((Throwable)t), failureCode));
    }
}

