/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Pair;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.ImmutableMetadataResult;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.internal.LocationFactory;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.datasense.DataSenseArtifact;
import org.mule.tooling.client.internal.serialization.XStreamFactory;

public class DataSenseMetadataCacheAdapter
implements DataSenseMetadataCacheProvider {
    private DataSenseArtifact dataSenseArtifact;
    private XStream xStream;

    public DataSenseMetadataCacheAdapter(DataSenseArtifact dataSenseArtifact) {
        this.dataSenseArtifact = dataSenseArtifact;
        this.xStream = XStreamFactory.createXStream();
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String componentId, Location location, Long timestamp, Callable<MetadataResult<ComponentMetadataDescriptor<OperationModel>>> callable) {
        Pair<MetadataCache, Map<String, String>> input = this.getDataSenseCache(location);
        String result = (String)((Object)((MetadataCache)input.getFirst()).getOperationMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, (Map)input.getSecond()), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.xStream.toXML((Object)runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.xStream.fromXML(result);
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String componentId, Location location, Long timestamp, Callable<MetadataResult<ComponentMetadataDescriptor<SourceModel>>> callable) {
        Pair<MetadataCache, Map<String, String>> input = this.getDataSenseCache(location);
        String result = (String)((Object)((MetadataCache)input.getFirst()).getSourceMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, (Map)input.getSecond()), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.xStream.toXML((Object)runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.xStream.fromXML(result);
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(String componentId, Location location, Long timestamp, Callable<MetadataResult<MetadataKeysContainer>> callable) {
        Pair<MetadataCache, Map<String, String>> input = this.getDataSenseCache(location);
        String result = (String)((Object)((MetadataCache)input.getFirst()).getMetadataKeys((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, (Map)input.getSecond()), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.xStream.toXML((Object)runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.xStream.fromXML(result);
    }

    private Pair<MetadataCache, Map<String, String>> getDataSenseCache(Location location) {
        Pair input;
        if (this.dataSenseArtifact.getParent().isPresent() && this.dataSenseArtifact.getParent().get().hasComponentModel(location)) {
            DataSenseArtifact parent = this.dataSenseArtifact.getParent().get();
            input = new Pair((Object)parent.getMetadataCache(), parent.getProperties());
        } else {
            input = new Pair((Object)this.dataSenseArtifact.getMetadataCache(), this.dataSenseArtifact.getProperties());
        }
        return input;
    }
}

