/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.api.DataSense;
import org.mule.datasense.api.DataSenseInfo;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.CachedDataSenseProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.api.metadataprovider.DefaultDataSenseProvider;
import org.mule.datasense.api.metadataprovider.ExtensionsProvider;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tooling.client.api.datasense.DataSenseComponentInfo;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DataSenseMetadataCacheAdapter;
import org.mule.tooling.client.internal.DataSensePartsFactory;
import org.mule.tooling.client.internal.DataSenseResolveFactory;
import org.mule.tooling.client.internal.LocationFactory;
import org.mule.tooling.client.internal.ToolingDataSenseMetadataProvider;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;
import org.mule.tooling.client.internal.datasense.DataSenseArtifact;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSenseService
implements DataSenseService,
Command {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String APP_TYPES_DATA = "application-types.xml";
    private static final String APP_TYPES_TEST_DATA = "application-types-test.xml";
    private DataSense dataSense = new DefaultDataSense();
    private DataSenseArtifact dataSenseArtifact;
    private AtomicBoolean disposed = new AtomicBoolean(false);

    protected DefaultDataSenseService() {
    }

    public DefaultDataSenseService(DataSenseArtifact dataSenseArtifact) {
        com.google.common.base.Preconditions.checkNotNull((Object)dataSenseArtifact, (Object)"dataSenseArtifact cannot be null");
        this.dataSenseArtifact = dataSenseArtifact;
    }

    public Optional<org.mule.tooling.client.api.datasense.DataSenseInfo> resolveDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        return DataSensePartsFactory.toDataSenseInfoDTO(this.internalResolveDataSense(dataSenseRequest));
    }

    public Optional<DataSenseComponentInfo> resolveComponentDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        return DataSensePartsFactory.toDataSenseComponentInfoDTO(this.internalResolveComponentDataSense(dataSenseRequest));
    }

    private Optional<DataSenseInfo> internalResolveDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        Location location = LocationFactory.fromLocationDTO(dataSenseRequest.getLocation());
        DataSenseMetadataCacheAdapter dataSenseMetadataCacheProvider = new DataSenseMetadataCacheAdapter(this.dataSenseArtifact);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Resolving DataSense for component location: %s on %s", dataSenseRequest.getLocation(), this.dataSenseArtifact));
        }
        try {
            ApplicationModel applicationModel = this.buildDataSenseApplicationModel(this.dataSenseArtifact.getToolingApplicationModel());
            DataSenseProvider dataSenseProvider = this.getDataSenseProvider(applicationModel, () -> ImmutableSet.builder().addAll(this.dataSenseArtifact.getExtensionModels()).build(), Optional.of(dataSenseMetadataCacheProvider), dataSenseRequest);
            return (Optional)ClassUtils.withContextClassLoader((ClassLoader)this.dataSenseArtifact.getArtifactClassLoader().getClassLoader(), () -> this.dataSense.resolve(DataSenseResolveFactory.fromDataSenseResolutionScopeDTO(dataSenseRequest.getDataSenseResolutionScope()), applicationModel, dataSenseProvider));
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, MissingToolingConfigurationException.class);
            throw new ToolingException(String.format("Error while resolving DataSense for location: %s on %s", location, this.dataSenseArtifact), (Throwable)e);
        }
    }

    private Optional<org.mule.datasense.api.DataSenseComponentInfo> internalResolveComponentDataSense(DataSenseRequest dataSenseRequest) {
        this.checkState();
        Location location = LocationFactory.fromLocationDTO(dataSenseRequest.getLocation());
        com.google.common.base.Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        DataSenseMetadataCacheAdapter dataSenseMetadataCacheProvider = new DataSenseMetadataCacheAdapter(this.dataSenseArtifact);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Resolving DataSense for location: %s on %s", dataSenseRequest.getLocation(), this.dataSenseArtifact));
        }
        try {
            ApplicationModel applicationModel = this.buildDataSenseApplicationModel(this.dataSenseArtifact.getToolingApplicationModel());
            DataSenseProvider dataSenseProvider = this.getDataSenseProvider(applicationModel, () -> ImmutableSet.builder().addAll(this.dataSenseArtifact.getExtensionModels()).build(), Optional.of(dataSenseMetadataCacheProvider), dataSenseRequest);
            return (Optional)ClassUtils.withContextClassLoader((ClassLoader)this.dataSenseArtifact.getArtifactClassLoader().getClassLoader(), () -> this.dataSense.resolveComponent(location, applicationModel, dataSenseProvider));
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, MissingToolingConfigurationException.class);
            throw new ToolingException(String.format("Error while resolving DataSense for location %s on %s", location, this.dataSenseArtifact), (Throwable)e);
        }
    }

    public void dispose() {
        this.disposed.compareAndSet(false, true);
    }

    private ApplicationModel buildDataSenseApplicationModel(ToolingApplicationModel toolingApplicationModel) {
        ArrayList<String> typesDataList = new ArrayList<String>();
        this.getApplicationTypes(APP_TYPES_DATA, this.dataSenseArtifact).ifPresent(typesData -> typesDataList.add((String)typesData));
        this.getApplicationTypes(APP_TYPES_TEST_DATA, this.dataSenseArtifact).ifPresent(typesData -> typesDataList.add((String)typesData));
        return new DefaultApplicationModel(toolingApplicationModel, typesDataList);
    }

    private Optional<String> getApplicationTypes(String resource, DataSenseArtifact dataSenseArtifact) {
        InputStream appTypeData = dataSenseArtifact.getArtifactClassLoader().getClassLoader().getResourceAsStream(resource);
        String typesData = null;
        if (appTypeData != null) {
            this.logger.debug("Found application custom types data from: " + resource);
            try {
                typesData = IOUtils.toString((InputStream)appTypeData);
            }
            catch (IOException e) {
                throw new ToolingException(String.format("Error while reading application custom types file: %s for %s", resource, dataSenseArtifact), (Throwable)e);
            }
        }
        return Optional.ofNullable(typesData);
    }

    private DataSenseProvider getDataSenseProvider(ApplicationModel applicationModel, ExtensionsProvider extensionsProvider, Optional<DataSenseMetadataCacheProvider> dataSenseMetadataCacheProvider, DataSenseRequest request) {
        DefaultDataSenseProvider dataSenseProvider = new DefaultDataSenseProvider(extensionsProvider, (DataSenseMetadataProvider)new ToolingDataSenseMetadataProvider(this.dataSenseArtifact, request.getMetadataTimeout()));
        if (dataSenseMetadataCacheProvider.isPresent()) {
            dataSenseProvider = new CachedDataSenseProvider(applicationModel, dataSenseMetadataCacheProvider.get(), (DataSenseProvider)dataSenseProvider);
        }
        return dataSenseProvider;
    }

    private void checkState() {
        com.google.common.base.Preconditions.checkState((!this.disposed.get() ? 1 : 0) != 0, (Object)"Service already disposed, cannot be used anymore");
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "resolveDataSense": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(DataSenseRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return SerializationUtilsImpl.serialize(this.resolveDataSense((DataSenseRequest)SerializationUtilsImpl.deserialize(arguments[0])));
            }
            case "resolveComponentDataSense": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(DataSenseRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return SerializationUtilsImpl.serialize(this.resolveComponentDataSense((DataSenseRequest)SerializationUtilsImpl.deserialize(arguments[0])));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }

    class DefaultApplicationModel
    implements ApplicationModel {
        private final ComponentModel rootComponentModel;
        private final ToolingApplicationModel toolingApplicationModel;
        private final List<String> typesData;

        DefaultApplicationModel(ToolingApplicationModel toolingApplicationModel, List<String> typesData) {
            this.toolingApplicationModel = toolingApplicationModel;
            this.typesData = typesData;
            ArrayList innerComponents = new ArrayList();
            toolingApplicationModel.getParent().ifPresent(parent -> innerComponents.addAll(parent.getMuleApplicationModel().getRootComponentModel().getInnerComponents()));
            innerComponents.addAll(toolingApplicationModel.getMuleApplicationModel().getRootComponentModel().getInnerComponents());
            ComponentModel.Builder builder = new ComponentModel.Builder();
            innerComponents.forEach(componentModel -> builder.addChildComponentModel(componentModel));
            builder.markAsRootComponent();
            builder.setIdentifier(toolingApplicationModel.getMuleApplicationModel().getRootComponentModel().getIdentifier());
            toolingApplicationModel.getMuleApplicationModel().getRootComponentModel().getCustomAttributes().forEach((name, value) -> builder.addCustomAttribute(name, value));
            this.rootComponentModel = builder.build();
        }

        public ComponentModel findRootComponentModel() {
            return this.rootComponentModel;
        }

        public Optional<ComponentModel> findNamedComponent(String name) {
            Optional found = Optional.empty();
            if (this.toolingApplicationModel.getParent().isPresent()) {
                found = this.toolingApplicationModel.getParent().get().getMuleApplicationModel().findNamedElement(name);
            }
            if (found.isPresent()) {
                return found;
            }
            return this.toolingApplicationModel.getMuleApplicationModel().findNamedElement(name);
        }

        public List<String> findTypesDataList() {
            return this.typesData;
        }

        public Optional<URI> findResource(String resource) {
            return this.toolingApplicationModel.findResource(resource);
        }

        public org.mule.runtime.config.internal.model.ApplicationModel getMuleApplicationModel() {
            return this.toolingApplicationModel.getMuleApplicationModel();
        }
    }
}

