/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.ApplicationConnectivityTestingService;
import org.mule.tooling.client.internal.ApplicationValueProviderService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultDataSenseService;
import org.mule.tooling.client.internal.DomainConnectivityTestingService;
import org.mule.tooling.client.internal.DomainValueProviderService;
import org.mule.tooling.client.internal.InternalApplicationMetadataProvider;
import org.mule.tooling.client.internal.InternalDomainMetadataProvider;
import org.mule.tooling.client.internal.ToolingMetadataServiceAdapter;
import org.mule.tooling.client.internal.UnavailableDataSenseService;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;
import org.mule.tooling.client.internal.datasense.DataSenseArtifact;
import org.mule.tooling.client.internal.dataweave.ApplicationRemoteRunner;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunnerProvider;
import org.mule.tooling.client.internal.dataweave.DefaultDataWeaveService;
import org.mule.tooling.client.internal.dataweave.DomainRemoteRunner;
import org.mule.tooling.client.internal.dataweave.LocalRunner;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;

public class DefaultToolingArtifact
implements ToolingArtifact,
Command {
    private String id;
    private Artifact artifact;
    private ConnectivityTestingService connectivityTestingService;
    private MetadataService metadataService;
    private DataSenseService dataSenseService;
    private DataWeaveService dataWeaveService;
    private ValueProviderService valueProviderService;
    private ToolingArtifact parentToolingArtifact;

    public DefaultToolingArtifact(String id, LazyValue<MetadataCache> metadataCache, Application application, ToolingArtifact parentToolingArtifact, LazyValue<MetadataCache> parentMetadataCache) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)application, (Object)"application cannot be null");
        Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        this.id = id;
        this.artifact = application;
        this.parentToolingArtifact = parentToolingArtifact;
        ApplicationRemoteRunner remoteRunner = null;
        LocalRunner localRunner = new LocalRunner((LazyValue<ClassLoader>)new LazyValue(() -> application.getArtifactClassLoader().getClassLoader()), (LazyValue<ConfigurationProperties>)new LazyValue(() -> application.getApplicationModel().getMuleApplicationModel().getConfigurationProperties()));
        InternalApplicationMetadataProvider metadataProvider = new InternalApplicationMetadataProvider(application);
        remoteRunner = new ApplicationRemoteRunner(application);
        this.connectivityTestingService = new ApplicationConnectivityTestingService(application);
        this.metadataService = new ToolingMetadataServiceAdapter((LazyValue<ApplicationModel>)new LazyValue(() -> application.getApplicationModel().getMuleApplicationModel()), metadataProvider, metadataCache, application.getProperties());
        DataSenseArtifact parentDataSenseArtifact = application.getDomain().map(domain -> new DataSenseArtifact((Artifact)domain, parentMetadataCache, new InternalDomainMetadataProvider((RemoteDomainInvoker)domain), domain.getProperties(), null)).orElse(null);
        DataSenseArtifact dataSenseArtifact = new DataSenseArtifact(application, metadataCache, metadataProvider, application.getProperties(), parentDataSenseArtifact);
        this.dataSenseService = new DefaultDataSenseService(dataSenseArtifact);
        this.valueProviderService = new ApplicationValueProviderService(application);
        this.dataWeaveService = new DefaultDataWeaveService((LazyValue<ClassLoader>)new LazyValue(() -> application.getArtifactClassLoader().getClassLoader()), new DataWeaveRunnerProvider(localRunner, remoteRunner), new ModulesAnalyzer());
    }

    public DefaultToolingArtifact(String id, LazyValue<MetadataCache> metadataCache, Domain domain) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        Preconditions.checkNotNull((Object)domain, (Object)"domain cannot be null");
        this.id = id;
        this.artifact = domain;
        DomainRemoteRunner remoteRunner = null;
        LocalRunner localRunner = new LocalRunner((LazyValue<ClassLoader>)new LazyValue(() -> domain.getArtifactClassLoader().getClassLoader()), (LazyValue<ConfigurationProperties>)new LazyValue(() -> domain.getApplicationModel().getMuleApplicationModel().getConfigurationProperties()));
        InternalDomainMetadataProvider metadataProvider = new InternalDomainMetadataProvider(domain);
        remoteRunner = new DomainRemoteRunner(domain);
        this.connectivityTestingService = new DomainConnectivityTestingService(domain);
        this.dataSenseService = new UnavailableDataSenseService(ArtifactType.DOMAIN);
        this.metadataService = new ToolingMetadataServiceAdapter((LazyValue<ApplicationModel>)new LazyValue(() -> domain.getApplicationModel().getMuleApplicationModel()), metadataProvider, metadataCache, domain.getProperties());
        this.valueProviderService = new DomainValueProviderService(domain);
        this.dataWeaveService = new DefaultDataWeaveService((LazyValue<ClassLoader>)new LazyValue(() -> domain.getArtifactClassLoader().getClassLoader()), new DataWeaveRunnerProvider(localRunner, remoteRunner), new ModulesAnalyzer());
    }

    public String getId() {
        return this.id;
    }

    public Optional<ToolingArtifact> getParent() {
        return Optional.ofNullable(this.parentToolingArtifact);
    }

    public Map<String, String> getProperties() {
        return this.artifact.getProperties();
    }

    public ConnectivityTestingService connectivityTestingService() {
        return this.connectivityTestingService;
    }

    public MetadataService metadataService() {
        return this.metadataService;
    }

    public DataSenseService dataSenseService() {
        return this.dataSenseService;
    }

    public DataWeaveService dataWeaveService() {
        return this.dataWeaveService;
    }

    public ValueProviderService valueProviderService() {
        return this.valueProviderService;
    }

    public void dispose() {
        this.artifact.dispose();
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "id": {
                return SerializationUtilsImpl.serialize(this.getId());
            }
            case "getParent": {
                return this.getParent();
            }
            case "connectivityTestingService": {
                return this.connectivityTestingService();
            }
            case "metadataService": {
                return this.metadataService();
            }
            case "dataSenseService": {
                return this.dataSenseService();
            }
            case "dataWeaveService": {
                return this.dataWeaveService();
            }
            case "valueProviderService": {
                return this.valueProviderService();
            }
            case "dispose": {
                this.dispose();
                return null;
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

