/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelServiceCache
implements Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE = "tooling.client.ExtensionModelServiceCache.maximumSize";
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS = "tooling.client.ExtensionModelServiceCache.expireAfterAccess";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelServiceCache.class);
    private static final String DEFAULT_MAX_SIZE = "100";
    private List<ExtensionModel> runtimeExtensionModels;
    private Cache<BundleDescriptor, Optional<LoadedExtensionInformation>> extensionModelsByArtifact = this.createExtensionModelCache();

    private Cache<BundleDescriptor, Optional<LoadedExtensionInformation>> createExtensionModelCache() {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue());
        this.cacheExpireAfterAccess().ifPresent(value -> builder.expireAfterAccess(value.longValue(), TimeUnit.SECONDS));
        return builder.build();
    }

    private Integer cacheMaximumSize() {
        Integer cacheSize = Integer.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE, DEFAULT_MAX_SIZE));
        Preconditions.checkArgument((cacheSize > 0 ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, the cache cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE));
        return cacheSize;
    }

    private Optional<Long> cacheExpireAfterAccess() {
        if (System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS) == null) {
            return Optional.empty();
        }
        Long cacheSize = Long.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS));
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, cacheExpireAfterAccess cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE));
        return Optional.of(cacheSize);
    }

    public ExtensionModelServiceCache() {
        LOGGER.info("Initialising Extension Model Service cache");
    }

    public Optional<LoadedExtensionInformation> loadExtensionInformation(BundleDescriptor bundleDescriptor, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> (Optional)this.extensionModelsByArtifact.get((Object)bundleDescriptor, () -> extensionModelService.loadExtensionData(bundleDescriptor)));
    }

    public Optional<LoadedExtensionInformation> loadExtensionInformation(File plugin, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> {
            ArtifactPluginDescriptor artifactPluginDescriptor = extensionModelService.readBundleDescriptor(plugin);
            return (Optional)this.extensionModelsByArtifact.get((Object)artifactPluginDescriptor.getBundleDescriptor(), () -> extensionModelService.loadExtensionData(artifactPluginDescriptor.getBundleDescriptor()));
        });
    }

    public List<ExtensionModel> loadRuntimeExtensionModels(InternalExtensionModelService extensionModelService) {
        if (this.runtimeExtensionModels == null) {
            this.runtimeExtensionModels = extensionModelService.loadRuntimeExtensionModels();
        }
        return this.runtimeExtensionModels;
    }

    public void dispose() {
        LOGGER.info("Disposing Extension Model Service cache");
        this.extensionModelsByArtifact.invalidateAll();
    }
}

