/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.ArtifactCopyNativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.tooling.ToolingApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationPluginDescriptorsResolver;
import org.mule.tooling.client.api.exception.ToolingException;

public class ApplicationClassLoaderFactory {
    private ArtifactClassLoader containerArtifactClassLoader;
    private RegionPluginClassLoadersFactory regionPluginClassLoadersFactory;
    private PluginDependenciesResolver pluginDependenciesResolver;
    private ApplicationPluginDescriptorsResolver applicationPluginDescriptorsResolver;

    public ApplicationClassLoaderFactory(ArtifactClassLoader containerArtifactClassLoader, RegionPluginClassLoadersFactory regionPluginClassLoadersFactory, PluginDependenciesResolver pluginDependenciesResolver, ApplicationPluginDescriptorsResolver applicationPluginDescriptorsResolver) {
        Objects.requireNonNull(containerArtifactClassLoader, "containerArtifactClassLoader cannot be null");
        Objects.requireNonNull(regionPluginClassLoadersFactory, "regionPluginClassLoadersFactory cannot be null");
        Objects.requireNonNull(pluginDependenciesResolver, "pluginDependenciesResolver cannot be null");
        Objects.requireNonNull(applicationPluginDescriptorsResolver, "pluginDependenciesResolver cannot be null");
        this.containerArtifactClassLoader = containerArtifactClassLoader;
        this.regionPluginClassLoadersFactory = regionPluginClassLoadersFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.applicationPluginDescriptorsResolver = applicationPluginDescriptorsResolver;
    }

    public ToolingArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor applicationDescriptor, File workingDirectory, ToolingArtifactClassLoader parentToolingArtifactClassLoader) {
        try {
            Object resolvedPluginsDescriptors;
            ToolingApplicationClassLoaderBuilder builder = new ToolingApplicationClassLoaderBuilder((DeployableArtifactClassLoaderFactory)new MuleApplicationClassLoaderFactory((NativeLibraryFinderFactory)new ToolingNativeLibraryFinderFactory(workingDirectory)), this.regionPluginClassLoadersFactory);
            boolean hasDomainDependency = applicationDescriptor.getDomainDescriptor().isPresent();
            if (!hasDomainDependency) {
                resolvedPluginsDescriptors = ImmutableList.builder().addAll((Iterable)applicationDescriptor.getPlugins()).build();
                builder.setParentClassLoader(this.containerArtifactClassLoader);
            } else {
                if (hasDomainDependency && parentToolingArtifactClassLoader == null) {
                    throw new IllegalStateException(String.format("'%s' declares a domain dependency '%s' that should have been already resolved", new Object[0]));
                }
                if (!((BundleDescriptor)applicationDescriptor.getDomainDescriptor().get()).equals((Object)parentToolingArtifactClassLoader.getArtifactDescriptor().getBundleDescriptor())) {
                    throw new IllegalStateException(String.format("Domain class loader to be set for application doesn't match the descriptor, expected: '%s', but was: '%s'", applicationDescriptor.getDomainDescriptor().get(), parentToolingArtifactClassLoader.getArtifactDescriptor().getBundleDescriptor()));
                }
                HashSet<ArtifactDescriptor> domainPluginDescriptors = new HashSet<ArtifactDescriptor>();
                for (ArtifactClassLoader artifactPluginClassLoader : parentToolingArtifactClassLoader.getArtifactPluginClassLoaders()) {
                    domainPluginDescriptors.add(artifactPluginClassLoader.getArtifactDescriptor());
                }
                builder.setDomainParentClassLoader((ArtifactClassLoader)parentToolingArtifactClassLoader.getRegionClassLoader());
                resolvedPluginsDescriptors = this.applicationPluginDescriptorsResolver.resolveArtifactPluginDescriptors(domainPluginDescriptors, applicationDescriptor.getPlugins());
            }
            this.pluginDependenciesResolver.resolve((List)resolvedPluginsDescriptors).stream().forEach(xva$0 -> builder.addArtifactPluginDescriptors(new ArtifactPluginDescriptor[]{xva$0}));
            builder.setArtifactDescriptor((ArtifactDescriptor)applicationDescriptor);
            return builder.build();
        }
        catch (Exception e) {
            throw new ToolingException("Error while creating application class loader", (Throwable)e);
        }
    }

    private class ToolingNativeLibraryFinderFactory
    implements NativeLibraryFinderFactory {
        private File workingDirectory;

        public ToolingNativeLibraryFinderFactory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public NativeLibraryFinder create(String name, URL[] urls) {
            return new ArtifactCopyNativeLibraryFinder(new File(new File(this.workingDirectory, name), "temp"), urls);
        }
    }
}

