/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.config.internal.model.ApplicationModel;

public class ToolingApplicationModel {
    private ToolingApplicationModel parent;
    private ApplicationModel muleApplicationModel;
    private ClassLoader classLoader;

    public ToolingApplicationModel(ToolingApplicationModel parent, ApplicationModel muleApplicationModel, ClassLoader classLoader) {
        Objects.requireNonNull(muleApplicationModel, "muleApplicationModel cannot be null");
        Objects.requireNonNull(muleApplicationModel, "muleApplicationModel cannot be null");
        this.parent = parent;
        this.muleApplicationModel = muleApplicationModel;
        this.classLoader = classLoader;
    }

    public Optional<ToolingApplicationModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ApplicationModel getMuleApplicationModel() {
        return this.muleApplicationModel;
    }

    public Optional<URI> findResource(String resource) {
        return Optional.ofNullable(this.classLoader.getResource(resource)).map(url -> FileUtils.toFile((URL)url).toURI());
    }
}

