/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.datasense.api.metadataprovider.ToolingHelper;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tooling.client.api.dataweave.DataWeaveModuleOption;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.dataweave.validation.DataWeaveValidationRequest;
import org.mule.tooling.client.api.el.Location;
import org.mule.tooling.client.api.el.Position;
import org.mule.tooling.client.api.el.Severity;
import org.mule.tooling.client.api.el.ValidationMessage;
import org.mule.tooling.client.api.el.ValidationResult;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunnerProvider;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.pojo.JavaDataFormat;

public class DefaultDataWeaveService
implements DataWeaveService,
Command {
    private final LazyValue<ClassLoader> executionClassLaoder;
    private DataWeaveRunnerProvider runnerProvider;
    private ModulesAnalyzer modulesAnalyzer;

    public DefaultDataWeaveService(LazyValue<ClassLoader> executionClassLoader, DataWeaveRunnerProvider runnerProvider, ModulesAnalyzer modulesAnalyzer) {
        this.executionClassLaoder = executionClassLoader;
        this.runnerProvider = runnerProvider;
        this.modulesAnalyzer = modulesAnalyzer;
    }

    public DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters) {
        EventModel event = parameters.getEvent();
        if (event != null && this.anyInputIsJavaBased(event)) {
            throw new IllegalArgumentException("Java input not supported, serialize to DW script");
        }
        return this.getRunnerProvider().getRunner(parameters).execute(parameters);
    }

    public ValidationResult validate(DataWeaveValidationRequest request) {
        return (ValidationResult)ClassUtils.withContextClassLoader((ClassLoader)((ClassLoader)this.executionClassLaoder.get()), () -> {
            final ArrayList validationMessages = new ArrayList();
            ExpressionLanguageMetadataTypeResolver.getInstance().getOutputType(ToolingHelper.resolveTypeBindings((MetadataType)request.getEventType(), (Map)request.getGlobalBindings(), (Map)request.getFunctionBindings()), request.getScript(), new ExpressionLanguageMetadataTypeResolver.MessageCallback(){

                public void warning(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation location) {
                    validationMessages.add(new ValidationMessage(Severity.WARNING, message, DefaultDataWeaveService.this.toLocation(location)));
                }

                public void error(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation location) {
                    validationMessages.add(new ValidationMessage(Severity.ERROR, message, DefaultDataWeaveService.this.toLocation(location)));
                }
            });
            return new ValidationResult(validationMessages);
        });
    }

    private Location toLocation(ExpressionLanguageMetadataTypeResolver.MessageLocation location) {
        ExpressionLanguageMetadataTypeResolver.MessagePosition startPosition = location.getStartPosition();
        ExpressionLanguageMetadataTypeResolver.MessagePosition endPosition = location.getEndPosition();
        return new Location(new Position(startPosition.getLine(), startPosition.getColumn(), startPosition.getOffset()), new Position(endPosition.getLine(), endPosition.getColumn(), endPosition.getOffset()));
    }

    private boolean anyInputIsJavaBased(EventModel event) {
        MessageModel message = event.getMessage();
        if (this.isJavaBased(message.getPayload()) || this.isJavaBased(message.getAttributes())) {
            return true;
        }
        Map variables = event.getVariables();
        return variables != null && variables.values().stream().anyMatch(this::isJavaBased);
    }

    private boolean isJavaBased(TypedValueModel model) {
        return model != null && JavaDataFormat.isJavaMimeType((String)model.getDataType().getMediaType());
    }

    public List<DataWeaveModuleOption> getReaderOptions(String contentType) {
        return this.getModulesAnalyzer().getOptions(contentType, DataFormat::readerOptions);
    }

    public List<DataWeaveModuleOption> getWriterOptions(String contentType) {
        return this.getModulesAnalyzer().getOptions(contentType, DataFormat::writerOptions);
    }

    public ModulesAnalyzer getModulesAnalyzer() {
        return this.modulesAnalyzer;
    }

    public DataWeaveRunnerProvider getRunnerProvider() {
        return this.runnerProvider;
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "execute": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(DataWeavePreviewRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return SerializationUtilsImpl.serialize(this.execute((DataWeavePreviewRequest)SerializationUtilsImpl.deserialize(arguments[0])));
            }
            case "validate": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(DataWeaveValidationRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return SerializationUtilsImpl.serialize(this.validate((DataWeaveValidationRequest)SerializationUtilsImpl.deserialize(arguments[0])));
            }
            case "getReaderOptions": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return SerializationUtilsImpl.serialize(this.getReaderOptions((String)SerializationUtilsImpl.deserialize(arguments[0])));
            }
            case "getWriterOptions": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return SerializationUtilsImpl.serialize(this.getWriterOptions((String)SerializationUtilsImpl.deserialize(arguments[0])));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

