/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.icons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.icons.DefaultIconsResult;
import org.mule.tooling.client.api.icons.ExtensionIconsService;
import org.mule.tooling.client.api.icons.IconsResult;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.serialization.SerializationUtilsImpl;

public class DefaultExtensionIconsService
implements ExtensionIconsService,
Command {
    private MavenClient mavenClient;
    private static final String SVG = ".svg";

    public DefaultExtensionIconsService(MavenClient mavenClient) {
        this.mavenClient = mavenClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IconsResult getIconsFor(ArtifactDescriptor artifactDescriptor) {
        BundleDependency bundleDependency = this.mavenClient.resolveBundleDescriptor(this.toBundleDescriptor(artifactDescriptor));
        URI bundleUri = bundleDependency.getBundleUri();
        try (ZipFile file = new ZipFile(new File(bundleUri));){
            Enumeration<? extends ZipEntry> entries = file.entries();
            HashMap<String, byte[]> additionalIcons = new HashMap<String, byte[]>();
            byte[] defaultIcon = null;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String iconPath = entry.getName();
                if (!iconPath.startsWith("META-INF/mule-artifact") || !iconPath.toLowerCase().endsWith(SVG)) continue;
                int i = iconPath.lastIndexOf(FileSystems.getDefault().getSeparator()) + 1;
                String iconName = iconPath.substring(i, iconPath.length() - 4);
                if (iconName.equals("icon")) {
                    defaultIcon = IOUtils.toByteArray((InputStream)file.getInputStream(entry));
                    continue;
                }
                additionalIcons.put(iconName, IOUtils.toByteArray((InputStream)file.getInputStream(entry)));
            }
            DefaultIconsResult defaultIconsResult = new DefaultIconsResult(defaultIcon, additionalIcons);
            return defaultIconsResult;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to retrieve icons.", e);
        }
    }

    private BundleDescriptor toBundleDescriptor(ArtifactDescriptor pluginDescriptor) {
        return new BundleDescriptor.Builder().setGroupId(pluginDescriptor.getGroupId()).setArtifactId(pluginDescriptor.getArtifactId()).setVersion(pluginDescriptor.getVersion()).setType(pluginDescriptor.getExtension()).setClassifier(pluginDescriptor.getClassifier()).build();
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        if (methodName.equals("getIconsFor")) {
            Object artifactDescriptor = SerializationUtilsImpl.deserialize(arguments[0]);
            IconsResult iconsResult = this.getIconsFor((ArtifactDescriptor)artifactDescriptor);
            return SerializationUtilsImpl.serialize(iconsResult);
        }
        throw Command.methodNotFound(DefaultExtensionIconsService.class, methodName);
    }
}

