/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.CachedExtensionModelService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultExtensionModelService;
import org.mule.tooling.client.internal.DefaultMuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClient;
import org.mule.tooling.client.internal.DomainCache;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DefaultToolingRuntimeClientBuilder
implements ToolingRuntimeClient.Builder,
Command {
    private String muleVersion;
    private Serializer serializer;
    private MavenClient mavenClient;
    private ModuleRepository moduleRepository;
    private ArtifactClassLoader containerClassLoaderFactory;
    private Optional<ExtensionModelServiceCache> extensionModelServiceCache;
    private ApplicationCache applicationCache;
    private DomainCache domainCache;
    private Optional<MetadataCacheFactory> metadataCacheFactoryOptional = Optional.empty();
    private DslSyntaxServiceCache dslSyntaxServiceCache;
    private AgentConfiguration agentConfiguration;

    public DefaultToolingRuntimeClientBuilder(String muleVersion, Serializer serializer, ModuleRepository moduleRepository, ArtifactClassLoader containerClassLoaderFactory, Optional<ExtensionModelServiceCache> extensionModelServiceCache, ApplicationCache applicationCache, DomainCache domainCache, DslSyntaxServiceCache dslSyntaxServiceCache) {
        this.muleVersion = muleVersion;
        this.serializer = serializer;
        this.moduleRepository = moduleRepository;
        this.containerClassLoaderFactory = containerClassLoaderFactory;
        this.extensionModelServiceCache = extensionModelServiceCache;
        this.applicationCache = applicationCache;
        this.domainCache = domainCache;
        this.dslSyntaxServiceCache = dslSyntaxServiceCache;
    }

    public ToolingRuntimeClient.Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public ToolingRuntimeClient.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenClient = MavenClientProvider.discoverProvider((ClassLoader)DefaultToolingRuntimeClientBuilder.class.getClassLoader()).createMavenClient(mavenConfiguration);
        return this;
    }

    public ToolingRuntimeClient.Builder withMetadataCacheFactory(MetadataCacheFactory metadataCacheFactory) {
        this.metadataCacheFactoryOptional = Optional.ofNullable(metadataCacheFactory);
        return this;
    }

    public ToolingRuntimeClient build() {
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(this.muleVersion, this.mavenClient, this.moduleRepository, this.containerClassLoaderFactory);
        DefaultExtensionModelService extensionModelService = new DefaultExtensionModelService(this.mavenClient, muleArtifactResourcesRegistry);
        MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider = new DefaultMuleRuntimeExtensionModelProvider(extensionModelService);
        if (this.extensionModelServiceCache.isPresent()) {
            muleRuntimeExtensionModelProvider = new CachedExtensionModelService(this.extensionModelServiceCache.get(), extensionModelService);
        }
        return new DefaultToolingRuntimeClient(this.mavenClient, this.serializer, Optional.ofNullable(this.agentConfiguration), muleRuntimeExtensionModelProvider, muleArtifactResourcesRegistry, this.applicationCache, this.domainCache, this.metadataCacheFactoryOptional, this.dslSyntaxServiceCache);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "withRemoteAgentConfiguration": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(AgentConfiguration.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.withRemoteAgentConfiguration((AgentConfiguration)this.serializer.deserialize(arguments[0]));
                return this;
            }
            case "withMavenConfiguration": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(MavenConfiguration.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.withMavenConfiguration((MavenConfiguration)this.serializer.deserialize(arguments[0]));
                return this;
            }
            case "build": {
                return this.build();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

