/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.extension.model.MuleVersion;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelServiceCache
implements Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE = "tooling.client.ExtensionModelServiceCache.maximumSize";
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS = "tooling.client.ExtensionModelServiceCache.expireAfterAccess";
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISKSTORE_PATH = "tooling.client.ExtensionModelServiceCache.diskStore.path";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelServiceCache.class);
    private static final String DEFAULT_MAX_SIZE = "100";
    private static final String MIN_MULE_VERSION = "minMuleVersion";
    private static final String EXTENSION_MODEL = "extensionModel";
    private MuleVersion muleVersion;
    private File diskStorePath;
    private List<ExtensionModel> runtimeExtensionModels;
    private Cache<BundleDescriptor, Optional<LoadedExtensionInformation>> extensionModelsByArtifact = this.createExtensionModelCache();

    private Cache<BundleDescriptor, Optional<LoadedExtensionInformation>> createExtensionModelCache() {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue());
        this.cacheExpireAfterAccess().ifPresent(value -> builder.expireAfterAccess(value.longValue(), TimeUnit.SECONDS));
        return builder.build();
    }

    private Integer cacheMaximumSize() {
        Integer cacheSize = Integer.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE, DEFAULT_MAX_SIZE));
        Preconditions.checkArgument((cacheSize > 0 ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, the cache cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE));
        return cacheSize;
    }

    private Optional<Long> cacheExpireAfterAccess() {
        if (System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS) == null) {
            return Optional.empty();
        }
        Long cacheSize = Long.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_EXPIRE_AFTER_ACCESS));
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, cacheExpireAfterAccess cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_MAXIMUM_SIZE));
        return Optional.of(cacheSize);
    }

    private File diskStorePath() {
        if (System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISKSTORE_PATH) == null) {
            return null;
        }
        File diskStorePath = new File(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISKSTORE_PATH));
        if (!diskStorePath.exists()) {
            boolean created = diskStorePath.mkdirs();
            Preconditions.checkArgument((boolean)created, (String)String.format("Couldn't create folders Extension Model service cache persistent data usinn path", diskStorePath));
        }
        return diskStorePath;
    }

    public ExtensionModelServiceCache(String muleVersion) {
        LOGGER.info("Initialising Extension Model Service cache");
        this.muleVersion = new MuleVersion(muleVersion);
        this.diskStorePath = this.diskStorePath();
        if (this.diskStorePath != null) {
            this.diskStorePath = new File(this.diskStorePath, String.format("%s.%s", this.muleVersion.getMajor(), this.muleVersion.getMinor()));
            if (!this.diskStorePath.exists()) {
                boolean created = this.diskStorePath.mkdirs();
                Preconditions.checkArgument((boolean)created, (String)String.format("Couldn't create folders Extension Model service cache persistent data using path", this.diskStorePath));
            }
            LOGGER.info("Enabling cache persistence for Extension Model Service on path '{}'", (Object)this.diskStorePath.getAbsolutePath());
        } else {
            LOGGER.info("Extension Model Service cache working in memory only");
        }
    }

    public Optional<LoadedExtensionInformation> loadExtensionInformation(BundleDescriptor bundleDescriptor, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> (Optional)this.extensionModelsByArtifact.get((Object)bundleDescriptor, () -> {
            if (this.diskStorePath != null && this.existExtensionModelFileFor(bundleDescriptor)) {
                try {
                    return this.loadExtensionModelFromDisk(bundleDescriptor);
                }
                catch (Exception e) {
                    LOGGER.warn("Error while loading {} Extension Model from file data, error: '{}'. It will be loaded again from jar file and writing to disk again", (Object)bundleDescriptor, (Object)e.getMessage());
                }
            }
            Optional<LoadedExtensionInformation> extensionInformation = extensionModelService.loadExtensionData(bundleDescriptor);
            if (this.diskStorePath != null) {
                this.writeExtensionModelToDisk(bundleDescriptor, extensionInformation);
            }
            return extensionInformation;
        }));
    }

    private boolean existExtensionModelFileFor(BundleDescriptor bundleDescriptor) {
        return this.getExtensionModelPersistenceFileFor(bundleDescriptor).exists();
    }

    private Optional<LoadedExtensionInformation> loadExtensionModelFromDisk(BundleDescriptor bundleDescriptor) {
        long startTime = System.nanoTime();
        try {
            File extensionModelFile = this.getExtensionModelPersistenceFileFor(bundleDescriptor);
            String content = FileUtils.readFileToString((File)extensionModelFile, (Charset)Charset.defaultCharset());
            Optional<Object> loadedExtensionInformation = Optional.ofNullable(null);
            JSONObject jsonObject = new JSONObject(content);
            if (jsonObject.length() != 0) {
                if (jsonObject.has(MIN_MULE_VERSION) && jsonObject.has(EXTENSION_MODEL)) {
                    ExtensionModel extensionModel = new ExtensionModelJsonSerializer().deserialize(jsonObject.get(EXTENSION_MODEL).toString());
                    File schemaFile = this.getExtensionSchemaPersistenceFileFor(bundleDescriptor);
                    Reference schemaContent = new Reference((Object)"");
                    if (schemaFile.exists()) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("No schema file found from disk cache for {}", (Object)bundleDescriptor);
                        }
                        schemaContent.set((Object)FileUtils.readFileToString((File)schemaFile, (Charset)Charset.defaultCharset()));
                    }
                    loadedExtensionInformation = Optional.of(new LoadedExtensionInformation(extensionModel, (LazyValue<String>)new LazyValue(() -> (String)schemaContent.get()), jsonObject.getString(MIN_MULE_VERSION)));
                } else {
                    LOGGER.warn("Ignoring file for {} as its content is invalid", (Object)bundleDescriptor);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Extension model for {} loaded from file disk in {}ms", (Object)bundleDescriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            return loadedExtensionInformation;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private File getExtensionModelPersistenceFileFor(BundleDescriptor bundleDescriptor) {
        return this.diskStorePath.toPath().resolve(this.getPathForBundleDescriptor(bundleDescriptor, "json")).toFile();
    }

    private File getExtensionSchemaPersistenceFileFor(BundleDescriptor bundleDescriptor) {
        return this.diskStorePath.toPath().resolve(this.getPathForBundleDescriptor(bundleDescriptor, "xsd")).toFile();
    }

    private void writeExtensionModelToDisk(BundleDescriptor bundleDescriptor, Optional<LoadedExtensionInformation> extensionInformation) {
        File extensionModelFile = this.getExtensionModelPersistenceFileFor(bundleDescriptor);
        File extensionSchemaFile = this.getExtensionSchemaPersistenceFileFor(bundleDescriptor);
        long startTime = System.nanoTime();
        extensionInformation.ifPresent(extensionModelData -> {
            block4: {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(MIN_MULE_VERSION, (Object)extensionModelData.getMinMuleVersion());
                jsonObject.put(EXTENSION_MODEL, (Object)new JSONObject(new ExtensionModelJsonSerializer(false).serialize(extensionModelData.getExtensionModel())));
                try {
                    FileUtils.writeStringToFile((File)extensionModelFile, (String)jsonObject.toString(2), (Charset)Charset.defaultCharset(), (boolean)false);
                    FileUtils.writeStringToFile((File)extensionSchemaFile, (String)((String)extensionModelData.getSchema().get()), (Charset)Charset.defaultCharset(), (boolean)false);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Extension model data for {} written to file disk in {}ms", (Object)bundleDescriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
                    }
                }
                catch (IOException e) {
                    LOGGER.warn(String.format("Couldn't write to disk data for Extension Model '{}'", bundleDescriptor), (Throwable)e);
                    if (extensionModelFile.exists()) {
                        FileUtils.deleteQuietly((File)extensionModelFile);
                    }
                    if (!extensionSchemaFile.exists()) break block4;
                    FileUtils.deleteQuietly((File)extensionSchemaFile);
                }
            }
        });
    }

    private String getPathForBundleDescriptor(BundleDescriptor bundleDescriptor, String extension) {
        StringBuilder path = new StringBuilder(128);
        path.append(bundleDescriptor.getGroupId().replace('.', '/')).append('/');
        path.append(bundleDescriptor.getArtifactId()).append('/');
        path.append(bundleDescriptor.getVersion()).append('/');
        path.append(bundleDescriptor.getArtifactId()).append('-');
        path.append(bundleDescriptor.getVersion());
        if (bundleDescriptor.getClassifier().isPresent()) {
            path.append('-').append((String)bundleDescriptor.getClassifier().get());
        }
        path.append('.').append(extension);
        return path.toString();
    }

    public Optional<LoadedExtensionInformation> loadExtensionInformation(File plugin, InternalExtensionModelService extensionModelService) {
        ArtifactPluginDescriptor artifactPluginDescriptor = extensionModelService.readBundleDescriptor(plugin);
        return this.loadExtensionInformation(artifactPluginDescriptor.getBundleDescriptor(), extensionModelService);
    }

    public List<ExtensionModel> loadRuntimeExtensionModels(InternalExtensionModelService extensionModelService) {
        if (this.runtimeExtensionModels == null) {
            this.runtimeExtensionModels = extensionModelService.loadRuntimeExtensionModels();
        }
        return this.runtimeExtensionModels;
    }

    public void dispose() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Disposing Extension Model Service cache");
        }
        this.extensionModelsByArtifact.invalidateAll();
    }
}

