/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.datasense;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;
import org.mule.tooling.client.internal.datasense.ApplicationModelUtils;

public class DataSenseArtifact {
    private Artifact artifact;
    private LazyValue<MetadataCache> metadataCache;
    private MetadataProvider metadataProvider;
    private Map<String, String> artifactProperties;
    private DataSenseArtifact parent;

    public DataSenseArtifact(Artifact artifact, LazyValue<MetadataCache> metadataCache, MetadataProvider metadataProvider, Map<String, String> artifactProperties, DataSenseArtifact parent) {
        this.artifact = artifact;
        this.metadataCache = metadataCache;
        this.metadataProvider = metadataProvider;
        this.artifactProperties = artifactProperties;
        this.parent = parent;
    }

    public MetadataCache getMetadataCache() {
        return (MetadataCache)this.metadataCache.get();
    }

    public boolean hasComponentModel(Location location) {
        return ApplicationModelUtils.findComponentWithLocation(this.artifact.getApplicationModel().getMuleApplicationModel().getRootComponentModel(), location).isPresent();
    }

    public Optional<DataSenseArtifact> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Map<String, String> getProperties() {
        return this.artifactProperties;
    }

    public List<ExtensionModel> getExtensionModels() {
        return this.artifact.getExtensionModels();
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public ToolingApplicationModel getToolingApplicationModel() {
        return this.artifact.getApplicationModel();
    }

    public ToolingArtifactClassLoader getArtifactClassLoader() {
        return this.artifact.getArtifactClassLoader();
    }

    public String toString() {
        return this.artifact.toString();
    }

    public MetadataProvider getMetadataProvider(Location location) {
        if (this.getParent().isPresent() && this.getParent().get().hasComponentModel(location)) {
            return this.getParent().get().getMetadataProvider();
        }
        return this.getMetadataProvider();
    }
}

