/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.mule.tooling.client.internal.serialization.Serializer;

/**
 * Application implementation for {@link ConnectivityTestingService}.
 *
 * @since 4.0
 */
public class ApplicationConnectivityTestingService extends AbstractConnectivityTestingService {

  private RemoteApplicationInvoker remoteApplicationInvoker;

  /**
   * Creates an instance of the service.
   *
   * @param remoteApplicationInvoker {@link RemoteApplicationInvoker} to deploy and resolve operations against a Mule Runtime. Non null.
   * @param serializer {@link Serializer} to serialize the object from API and responses. Non null.
   */
  public ApplicationConnectivityTestingService(RemoteApplicationInvoker remoteApplicationInvoker, Serializer serializer) {
    super(serializer);
    requireNonNull(remoteApplicationInvoker, "remoteApplicationInvoker cannot be null");

    this.remoteApplicationInvoker = remoteApplicationInvoker;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ConnectionValidationResult doTestConnection(ConnectivityTestingRequest connectivityTestingRequest) {
    return remoteApplicationInvoker
        .evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService
            .testConnectionApplication(applicationId,
                                       connectivityTestingRequest.getComponentId(),
                                       connectivityTestingRequest.getRequestTimeout()));
  }

}
