/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import static org.mule.tooling.client.internal.LocationFactory.fromLocationDTO;
import org.mule.tooling.client.api.datasense.ApplicationResolutionScope;
import org.mule.tooling.client.api.datasense.ComponentResolutionScope;
import org.mule.tooling.client.api.datasense.ConfigResolutionScope;
import org.mule.tooling.client.api.datasense.DataSenseResolutionScope;
import org.mule.tooling.client.internal.datasense.DataSenseResolutionScopeVisitor;

public class DataSenseResolveFactory {

  public static org.mule.datasense.api.DataSenseResolutionScope fromDataSenseResolutionScopeDTO(DataSenseResolutionScope dataSenseResolutionScope) {
    FactoryVisitor visitor = new FactoryVisitor();
    dataSenseResolutionScope.accept(visitor);
    return visitor.getDataSenseResolutionScope();
  }

  private static class FactoryVisitor implements DataSenseResolutionScopeVisitor {

    org.mule.datasense.api.DataSenseResolutionScope resolutionScope;

    @Override
    public void visit(ApplicationResolutionScope resolutionScope) {
      this.resolutionScope = new org.mule.datasense.api.ApplicationResolutionScope();
    }

    @Override
    public void visit(ConfigResolutionScope resolutionScope) {
      this.resolutionScope = new org.mule.datasense.api.ConfigResolutionScope(resolutionScope.getMuleConfigRelativeFile());
    }

    @Override
    public void visit(ComponentResolutionScope resolutionScope) {
      this.resolutionScope = new org.mule.datasense.api.ComponentResolutionScope(fromLocationDTO(resolutionScope.getLocation()));
    }

    public org.mule.datasense.api.DataSenseResolutionScope getDataSenseResolutionScope() {
      return resolutionScope;
    }
  }

}
