/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.runtime.api.value.ValueResult;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;
import org.mule.tooling.client.internal.serialization.Serializer;

/**
 * Implementation for retrieving value providers for domains.
 *
 * @since 4.1
 */
public class DomainValueProviderService extends AbstractValueProviderService {

  private RemoteDomainInvoker remoteDomainInvoker;

  /**
   * Creates an instance of this service.
   *
   * @param remoteDomainInvoker {@link RemoteDomainInvoker} to retrieve values for a Domain from Mule Runtime. Non null.
   */
  public DomainValueProviderService(RemoteDomainInvoker remoteDomainInvoker, Serializer serializer) {
    super(serializer);
    this.remoteDomainInvoker = remoteDomainInvoker;
  }

  @Override
  protected ValueResult doGetValue(ValueProviderRequest valueProviderRequest) {
    return remoteDomainInvoker.evaluateWithRemoteDomain((domainId,
                                                         runtimeToolingService) -> runtimeToolingService
                                                             .getValuesDomain(domainId,
                                                                              valueProviderRequest
                                                                                  .getLocation(),
                                                                              valueProviderRequest
                                                                                  .getProviderName()));

  }
}
