/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;

import java.util.concurrent.locks.ReentrantLock;

/**
 * Represents a Mule domain artifact.
 *
 * @since 4.1
 */
//TODO unify invokers to internally do the adapter!
public interface Domain extends Artifact, RemoteDomainInvoker {

  /**
   * @return {@link DomainDescriptor} for this domain artifact.
   */
  DomainDescriptor getDescriptor();

  /**
   * @return a {@link ReentrantLock} to control access over remote operations from a Domain.
   */
  ReentrantLock getRemoteInvokerLock();

}
